/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.RestClientConfig;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.PasswordDecryptor;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseRestController {
    @Autowired
    public Config config;
    protected RestClientConfig clientConfig;
    protected String apiKey = "";

    @PostConstruct
    public void init() {
        this.clientConfig = this.config.getCashier().getRestClientConfig();
        this.apiKey = PasswordDecryptor.decryptPassword((String)this.clientConfig.getEncAPIKey());
    }

    protected <T> ResponseEntity<T> processRequest(Map<String, String> headers, Supplier<T> successSupplier) {
        if (this.isValidRequest(headers)) {
            return new ResponseEntity(successSupplier.get(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    protected boolean isValidRequest(Map<String, String> headers) {
        return headers.containsKey("x-api-key") && !Objects.equals(headers.get("x-api-key"), "") && headers.get("x-api-key").equals(this.apiKey);
    }

    void saveRequestBodyToFile(String rawBody, String fileName) throws IOException {
        try {
            File file = new File("/home/user/spagetka/logs/api/" + fileName.replace(" ", "_").replace(":", "-"));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(rawBody.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public String extractRequestBodyUsingReflection(HttpServletRequest request) {
        try {
            if (!(request instanceof RequestFacade)) {
                throw new IllegalArgumentException("Request is not a RequestFacade");
            }
            Field requestField = RequestFacade.class.getDeclaredField("request");
            requestField.setAccessible(true);
            Request internalRequest = (Request)requestField.get(request);
            Field inputBufferField = Request.class.getDeclaredField("inputBuffer");
            inputBufferField.setAccessible(true);
            Object inputBuffer = inputBufferField.get(internalRequest);
            Field bbField = inputBuffer.getClass().getDeclaredField("bb");
            bbField.setAccessible(true);
            ByteBuffer byteBuffer = (ByteBuffer)bbField.get(inputBuffer);
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to extract request body", e);
        }
    }
}

