/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.User;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="InventoryCheckReports")
public class InventoryCheckReportItem {
    private String id;
    private LocalDateTime dateTime;
    private StockItem stockItem;
    private String qrCode;
    private Double originalQuantity;
    private Double newQuantity;
    @Transient
    private DoubleProperty newQuantityProperty = new SimpleDoubleProperty(0.0);
    private Double difference;
    private String location;
    private User user;

    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    public String getId() {
        return this.id;
    }

    @Column
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @ManyToOne(cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    public StockItem getStockItem() {
        return this.stockItem;
    }

    @Column
    public String getQrCode() {
        return this.qrCode;
    }

    @Column
    public Double getOriginalQuantity() {
        return this.originalQuantity;
    }

    @Column
    public Double getDifference() {
        return this.difference;
    }

    @Column
    public String getLocation() {
        return this.location;
    }

    @ManyToOne(cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinColumn(name="user_id")
    public User getUser() {
        return this.user;
    }

    @Transient
    public DoubleProperty getNewQuantityProperty() {
        return this.newQuantityProperty;
    }

    @Column
    public Double getNewQuantity() {
        if (this.newQuantityProperty != null) {
            return this.newQuantityProperty.get();
        }
        return this.newQuantity;
    }

    public void setNewQuantity(Double value) {
        this.newQuantity = value;
        if (this.newQuantityProperty != null) {
            this.newQuantityProperty.set(value.doubleValue());
        }
    }

    public InventoryCheckReportItem() {
    }

    public InventoryCheckReportItem(String id, LocalDateTime dateTime, StockItem stockItem, String qrCode, Double originalQuantity, Double newQuantity, DoubleProperty newQuantityProperty, Double difference, String location, User user) {
        this.id = id;
        this.dateTime = dateTime;
        this.stockItem = stockItem;
        this.qrCode = qrCode;
        this.originalQuantity = originalQuantity;
        this.newQuantity = newQuantity;
        this.newQuantityProperty = newQuantityProperty;
        this.difference = difference;
        this.location = location;
        this.user = user;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public void setStockItem(StockItem stockItem) {
        this.stockItem = stockItem;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public void setOriginalQuantity(Double originalQuantity) {
        this.originalQuantity = originalQuantity;
    }

    public void setNewQuantityProperty(DoubleProperty newQuantityProperty) {
        this.newQuantityProperty = newQuantityProperty;
    }

    public void setDifference(Double difference) {
        this.difference = difference;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

