/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.CalcUtils;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class FormatUtils {
    public static String formatOneDecimalForce(double number) {
        return String.format("%,.1f", CalcUtils.roundNumber((Double)number, (int)1));
    }

    public static String formatCurrencyForceDecimal(double number) {
        return String.format("%,.2f", CalcUtils.roundNumber((Double)number, (int)2));
    }

    public static String formatCurrencyForceDecimal(double number, String currency) {
        return String.format("%,.2f " + currency, CalcUtils.roundNumber((Double)number, (int)2));
    }

    public static String formatCurrency(double number) {
        DecimalFormat fmt = new DecimalFormat("0.##");
        return fmt.format(CalcUtils.roundNumber((Double)number, (int)2));
    }

    public static String formatCurrency(double number, String currency) {
        DecimalFormat fmt = new DecimalFormat("0.##");
        return fmt.format(CalcUtils.roundNumber((Double)number, (int)2)) + " " + currency;
    }

    public static String formatOneDecimalForce(BigDecimal number) {
        return String.format("%,.1f", CalcUtils.roundNumber((BigDecimal)number, (int)1));
    }

    public static String formatCurrencyForceDecimal(BigDecimal number) {
        return String.format("%,.2f", CalcUtils.roundNumber((BigDecimal)number, (int)2));
    }

    public static String formatCurrencyForceDecimal(BigDecimal number, String currency) {
        return String.format("%,.2f " + currency, CalcUtils.roundNumber((BigDecimal)number, (int)2));
    }

    public static String formatCurrency(BigDecimal number) {
        DecimalFormat fmt = new DecimalFormat("0.##");
        return fmt.format(CalcUtils.roundNumber((BigDecimal)number, (int)2));
    }

    public static String formatCurrency(BigDecimal number, String currency) {
        DecimalFormat fmt = new DecimalFormat("0.##");
        return fmt.format(CalcUtils.roundNumber((BigDecimal)number, (int)2)) + " " + currency;
    }

    public static String getQuantityLabel(int number) {
        return String.valueOf(number) + " x";
    }

    public static String formatDateTime(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"));
    }

    public static String formatTime(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    public static String formatDate(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
    }

    public static LocalDateTime parseDateTime(String dateTimeString) {
        if (dateTimeString == null || dateTimeString.trim().isEmpty()) {
            return null;
        }
        try {
            LocalDateTime dateTime = LocalDateTime.parse(dateTimeString);
            return dateTime;
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }
}

