/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantCategoryDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantDTO;
import cz.polreich.spagetka.DTO.ProductVariantDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.popup.cashierController.UpdatePopup;
import cz.polreich.spagetka.models.Allergen;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductFreeVariantCategory;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.external.UserExternal;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdatePopup
extends Popup {
    private CashierController cashierController;
    private Label descriptionLabel;
    private List<Product> filteredProducts = new ArrayList();

    public UpdatePopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 650;
        int popupHeight = 700;
        AnchorPane popupAnchor = new AnchorPane();
        Label labelTitle = new Label();
        labelTitle.setText("Aktualizace dat");
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)10.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)10.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 40px;");
        this.descriptionLabel = new Label("");
        this.descriptionLabel.setMaxWidth(300.0);
        this.descriptionLabel.setAlignment(Pos.CENTER);
        this.descriptionLabel.setFont(cashierController.mainSceneButtonsFont);
        AnchorPane.setTopAnchor((Node)this.descriptionLabel, (Double)170.0);
        AnchorPane.setLeftAnchor((Node)this.descriptionLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.descriptionLabel, (Double)10.0);
        popupAnchor.setMinWidth((double)popupWidth);
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.setMaxHeight((double)popupHeight);
        popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, this.descriptionLabel});
        this.getContent().add((Object)popupAnchor);
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
        1 downloadTask = new /* Unavailable Anonymous Inner Class!! */;
        new Thread((Runnable)downloadTask).start();
    }

    private void downloadDataFromPartnerServer() {
        Platform.runLater(() -> this.descriptionLabel.setText("Pripravuji databazi..."));
        this.prepareDB();
        PartnerServerRestClient partnerServerRestClient = new PartnerServerRestClient(this.cashierController.activeConfig.getRestClientConfig());
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji kategorie..."));
        this.cashierController.activeConfig.setPartnerServerRestClient(partnerServerRestClient);
        List categoriesDTO = partnerServerRestClient.getCategories();
        List<Category> categories = categoriesDTO.stream().map(c -> new Category(c, true)).toList();
        this.cashierController.categoryService.saveAll(categories);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji ingredience..."));
        List<Ingredient> ingredients = partnerServerRestClient.getIngredients().stream().map(Ingredient::new).toList();
        this.cashierController.ingredientService.saveAll(ingredients);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji produkty..."));
        List productsDTO = partnerServerRestClient.getProducts();
        List<Product> products = productsDTO.stream().map(p -> new Product(p, true)).toList();
        this.filteredProducts = new ArrayList<Product>(products);
        for (Product product : products) {
            this.calculateProductAvailability(product);
            if (product.getCategory() == this.cashierController.activeConfig.getSpaghettiCategoryId() || product.getCategory() == this.cashierController.activeConfig.getFusilliCategoryId()) {
                this.processPastaIngredients(product);
            }
            if (product.getProductVariants() != null && !product.getProductVariants().isEmpty() && product.getCategory() == this.cashierController.activeConfig.getCoffeeCategoryId()) {
                this.processCoffeeVariants(product);
            }
            if (product.getProductFreeVariantCategories() == null || product.getProductFreeVariantCategories().isEmpty() || product.getCategory() != this.cashierController.activeConfig.getIceCreamCategoryId()) continue;
            this.processIceCreamVariants(product);
        }
        this.cashierController.productService.saveAll(this.filteredProducts);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji prod. skupiny..."));
        List<ProductsGroup> productsGroups = partnerServerRestClient.getProductsGroups().stream().map(ProductsGroup::new).toList();
        this.cashierController.productsGroupService.saveAll(productsGroups);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji menu..."));
        List menuOptionsDTO = partnerServerRestClient.getMenuOptions();
        List<MenuOption> menuOptions = menuOptionsDTO.stream().map(m -> new MenuOption(m, true)).toList();
        this.cashierController.menuOptionService.saveAll(menuOptions);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji informace o kiosku..."));
        KioskInfo kioskInfo = new KioskInfo(partnerServerRestClient.getInfo());
        this.cashierController.activeConfig.setKioskInfo(kioskInfo);
        this.cashierController.kioskInfoService.save(kioskInfo);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji uzivatele..."));
        List usersExternal = partnerServerRestClient.getUsers();
        List<User> kioskUsers = usersExternal.stream().filter(UserExternal::isAccessKiosk).map(User::new).toList();
        this.cashierController.userService.saveAll(kioskUsers);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji alergeny..."));
        List<Allergen> allergens = partnerServerRestClient.getAllergens().stream().map(Allergen::new).toList();
        this.cashierController.allergenService.saveAll(allergens);
        Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky kategorii..."));
        for (CategoryDTO dto : categoriesDTO) {
            System.out.println("Downloading Category image: " + dto.getImageFilePath());
            partnerServerRestClient.downloadResource(dto.getImageFilePath());
        }
        Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky produktu..."));
        for (CategoryDTO dto : productsDTO) {
            System.out.println("Downloading Product image: " + dto.getImageFilePath());
            partnerServerRestClient.downloadResource(dto.getImageFilePath());
            Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky variant..."));
            for (ProductVariantDTO variantDTO : dto.getVariants()) {
                System.out.println("Downloading Variant image: " + variantDTO.getImageFilePath());
                partnerServerRestClient.downloadResource(variantDTO.getImageFilePath());
            }
            Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky freeVariant..."));
            for (ProductFreeVariantCategoryDTO variantCategory : dto.getCategoriesVariants()) {
                for (ProductFreeVariantDTO variantDTO : variantCategory.getFreeVariants()) {
                    System.out.println("Downloading FreeVariant image: " + variantDTO.getImageFilePath());
                    partnerServerRestClient.downloadResource(variantDTO.getImageFilePath());
                }
            }
        }
        Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky menu..."));
        for (CategoryDTO dto : menuOptionsDTO) {
            System.out.println("Downloading MenuOption image: " + dto.getImageFilePath());
            partnerServerRestClient.downloadResource(dto.getImageFilePath());
        }
        Platform.runLater(() -> this.descriptionLabel.setText("Synchronizuji obrazky..."));
        this.syncImagesToOrder();
    }

    protected void syncImagesToOrder() {
        System.out.println("Syncing images to Order1");
        ResourceHelper.syncImagesByNameOnly((String)"/home/user/spagetka/resources/images", (String)"/home/user/spagetka/resources/images", (String)"kioskOrder1.local");
        System.out.println("Syncing images to Order2");
        ResourceHelper.syncImagesByNameOnly((String)"/home/user/spagetka/resources/images", (String)"/home/user/spagetka/resources/images", (String)"kioskOrder2.local");
    }

    private void prepareDB() {
        this.cashierController.productService.removeAllCompositionItemsFromProducts();
        this.cashierController.productVariantService.removeAllCompositionItemsFromProductVariants();
        this.cashierController.compositionItemService.deleteAll();
        this.createPastaIngredients();
        this.cashierController.menuOptionService.disableAllMenuOptions();
    }

    private void processCoffeeVariants(Product product) {
        List variants = product.getProductVariants();
        for (ProductVariant variant : variants) {
            ProductVariant variantFromProduct = new ProductVariant(product);
            List existingProductList = this.filteredProducts.stream().filter(p -> p.getName().equals(variant.getName())).collect(Collectors.toList());
            if (existingProductList.isEmpty()) {
                Product productFromVariant = new Product(variant, product, true);
                productFromVariant.addVariant(variantFromProduct);
                this.calculateProductAvailability(productFromVariant);
                this.filteredProducts.add(productFromVariant);
                continue;
            }
            Product existingProduct = (Product)existingProductList.get(0);
            Product newProduct = new Product(existingProduct);
            newProduct.addVariant(variantFromProduct);
            this.filteredProducts.remove(existingProduct);
            this.filteredProducts.add(newProduct);
        }
        this.filteredProducts.remove(product);
        product.setEnabled(false);
        for (ProductVariant vari : product.getProductVariants()) {
            vari.setEnabled(false);
        }
        this.filteredProducts.add(product);
    }

    private void processIceCreamVariants(Product product) {
        for (ProductFreeVariantCategory variantCategory : product.getProductFreeVariantCategories()) {
            if (!ValidationUtils.isListNotNullOrEmpty((List)variantCategory.getFreeVariants())) continue;
            for (ProductFreeVariant variant : variantCategory.getFreeVariants()) {
                if (variant.getPrice() != null) continue;
                variant.setPrice(this.cashierController.activeConfig.getFreeVariantPrice());
            }
            ProductFreeVariant emptyVariant = new ProductFreeVariant();
            emptyVariant.setId("0" + variantCategory.getId());
            emptyVariant.setName("\u017d\u00e1dn\u00e9");
            emptyVariant.setImageFilePath("/resources/images/red_cross.png");
            emptyVariant.setPrice(Double.valueOf(0.0));
            emptyVariant.setEnabled(true);
            emptyVariant.setImageBytes(new byte[0]);
            ArrayList<ProductFreeVariant> newVariantList = new ArrayList<ProductFreeVariant>(variantCategory.getFreeVariants());
            newVariantList.add(emptyVariant);
            variantCategory.setFreeVariants(newVariantList);
        }
    }

    private void createPastaIngredients() {
        String spaghettiId = this.cashierController.activeConfig.getSpaghettiIngredientId();
        String fusilliId = this.cashierController.activeConfig.getFusilliIngredientId();
        if (!this.cashierController.ingredientService.existsById(spaghettiId)) {
            Ingredient spaghettiIngredient = new Ingredient();
            spaghettiIngredient.setId(spaghettiId);
            spaghettiIngredient.setName("\u0160pagety");
            spaghettiIngredient.setUnit("pc");
            spaghettiIngredient.setCookSee(Boolean.valueOf(true));
            spaghettiIngredient.setAlternativeUnit("pc");
            spaghettiIngredient.setAlternativeUnitRatio(Double.valueOf(1.0));
            spaghettiIngredient.setCriticalComponent(Boolean.valueOf(true));
            this.cashierController.ingredientService.save(spaghettiIngredient);
        }
        if (!this.cashierController.ingredientService.existsById(fusilliId)) {
            Ingredient fusilliIngredient = new Ingredient();
            fusilliIngredient.setId(fusilliId);
            fusilliIngredient.setName("Fusilli");
            fusilliIngredient.setUnit("pc");
            fusilliIngredient.setCookSee(Boolean.valueOf(true));
            fusilliIngredient.setAlternativeUnit("pc");
            fusilliIngredient.setAlternativeUnitRatio(Double.valueOf(1.0));
            fusilliIngredient.setCriticalComponent(Boolean.valueOf(true));
            this.cashierController.ingredientService.save(fusilliIngredient);
        }
    }

    private void processPastaIngredients(Product product) {
        CompositionItem compositionItem = new CompositionItem();
        if (product.getCategory() == this.cashierController.activeConfig.getSpaghettiCategoryId()) {
            compositionItem.setIngredient(this.cashierController.ingredientService.findById(this.cashierController.activeConfig.getSpaghettiIngredientId()));
            compositionItem.setQuantity(this.cashierController.activeConfig.getSpaghettiPortionMultiplier());
        } else if (product.getCategory() == this.cashierController.activeConfig.getFusilliCategoryId()) {
            compositionItem.setIngredient(this.cashierController.ingredientService.findById(this.cashierController.activeConfig.getFusilliIngredientId()));
            compositionItem.setQuantity(this.cashierController.activeConfig.getFusilliPortionMultiplier());
        }
        product.getIngredients().add(compositionItem);
    }

    private void calculateProductAvailability(Product product) {
        boolean available = true;
        for (CompositionItem compositionItem : product.getIngredients()) {
            if (!compositionItem.getIngredient().getCriticalComponent().booleanValue()) continue;
        }
        product.setAvailable(available);
    }

    public void hidePopup() {
        this.descriptionLabel.setText("");
        this.hide();
    }
}

