/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import cz.polreich.spagetka.models.StockItem;
import io.swagger.v3.oas.annotations.media.Schema;

public class StockItemDTO {
    @Schema(example="e5c40afe-3a9a-4427-ba6d-73e3be966f1d", requiredMode=Schema.RequiredMode.REQUIRED)
    private String id;
    @Schema(example="d552c811-adc4-4b81-a7dc-01fd67965708", requiredMode=Schema.RequiredMode.REQUIRED)
    private String ingredientId;
    @Schema(example="150", requiredMode=Schema.RequiredMode.REQUIRED)
    private Double quantity;
    @Schema(example="B1", requiredMode=Schema.RequiredMode.REQUIRED)
    private String location;
    @Schema(example="2024-05-15", requiredMode=Schema.RequiredMode.REQUIRED, pattern="^\\d{4}\\-(0?[1-9]|1[012])\\-(0?[1-9]|[12][0-9]|3[01])$")
    private String expiration;
    private String qrcode;
    @JsonProperty(value="critical_component")
    private Boolean criticalComponent;
    @JsonProperty(value="cook_see")
    private Boolean cookSee;

    public StockItemDTO(StockItem stockItem) {
        this.id = stockItem.getId();
        this.ingredientId = stockItem.getIngredient().getId();
        this.quantity = stockItem.getQuantity();
        this.location = stockItem.getLocation();
        this.expiration = String.valueOf(stockItem.getExpirationDate());
        this.qrcode = stockItem.getQrcode();
        this.criticalComponent = stockItem.getCriticalComponent();
        this.cookSee = stockItem.getCookRelevant();
    }

    public StockItemDTO() {
    }

    public StockItemDTO(String id, String ingredientId, Double quantity, String location, String expiration, String qrcode, Boolean criticalComponent, Boolean cookSee) {
        this.id = id;
        this.ingredientId = ingredientId;
        this.quantity = quantity;
        this.location = location;
        this.expiration = expiration;
        this.qrcode = qrcode;
        this.criticalComponent = criticalComponent;
        this.cookSee = cookSee;
    }

    public String getId() {
        return this.id;
    }

    public String getIngredientId() {
        return this.ingredientId;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public Boolean getCriticalComponent() {
        return this.criticalComponent;
    }

    public Boolean getCookSee() {
        return this.cookSee;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIngredientId(String ingredientId) {
        this.ingredientId = ingredientId;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    @JsonProperty(value="critical_component")
    public void setCriticalComponent(Boolean criticalComponent) {
        this.criticalComponent = criticalComponent;
    }

    @JsonProperty(value="cook_see")
    public void setCookSee(Boolean cookSee) {
        this.cookSee = cookSee;
    }
}

