/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.models.ProductFreeVariant;
import java.util.Arrays;
import java.util.Base64;

public class ProductFreeVariantDTO {
    private String id;
    private String name;
    private Double price;
    private String imageFilePath;
    private String imageBytesBase64;
    private String remoteImagePath;
    private Boolean allowedAtKiosk = true;
    private Integer order = 999;

    public ProductFreeVariantDTO(ProductFreeVariant productFreeVariant) {
        this.id = productFreeVariant.getId();
        this.name = productFreeVariant.getName();
        this.price = productFreeVariant.getPrice();
        this.imageFilePath = productFreeVariant.getImageFilePath();
        this.imageBytesBase64 = productFreeVariant.getImageBytes() == null ? null : Arrays.toString(Base64.getEncoder().encode(productFreeVariant.getImageBytes()));
        this.allowedAtKiosk = productFreeVariant.isEnabled();
        this.order = productFreeVariant.getItemOrder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public String getImageBytesBase64() {
        return this.imageBytesBase64;
    }

    public String getRemoteImagePath() {
        return this.remoteImagePath;
    }

    public Boolean getAllowedAtKiosk() {
        return this.allowedAtKiosk;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytesBase64(String imageBytesBase64) {
        this.imageBytesBase64 = imageBytesBase64;
    }

    public void setRemoteImagePath(String remoteImagePath) {
        this.remoteImagePath = remoteImagePath;
    }

    public void setAllowedAtKiosk(Boolean allowedAtKiosk) {
        this.allowedAtKiosk = allowedAtKiosk;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public ProductFreeVariantDTO() {
    }

    public ProductFreeVariantDTO(String id, String name, Double price, String imageFilePath, String imageBytesBase64, String remoteImagePath, Boolean allowedAtKiosk, Integer order) {
        this.id = id;
        this.name = name;
        this.price = price;
        this.imageFilePath = imageFilePath;
        this.imageBytesBase64 = imageBytesBase64;
        this.remoteImagePath = remoteImagePath;
        this.allowedAtKiosk = allowedAtKiosk;
        this.order = order;
    }
}

