/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.AttendanceLogItemDTO;
import cz.polreich.spagetka.models.enums.ATTENDANCE_ACTION;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name="AttendanceLog")
public class AttendanceLogItem {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @Column
    private int userId;
    @Column
    @Enumerated(value=EnumType.STRING)
    private ATTENDANCE_ACTION attendanceAction;
    @Column
    private LocalDateTime timestamp;

    public AttendanceLogItem(AttendanceLogItemDTO dto) {
        this.id = dto.getId();
        this.userId = dto.getUserId();
        this.attendanceAction = dto.getAttendanceAction();
        this.timestamp = LocalDateTime.parse(dto.getTimestamp());
    }

    public String getId() {
        return this.id;
    }

    public int getUserId() {
        return this.userId;
    }

    public ATTENDANCE_ACTION getAttendanceAction() {
        return this.attendanceAction;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setAttendanceAction(ATTENDANCE_ACTION attendanceAction) {
        this.attendanceAction = attendanceAction;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public AttendanceLogItem() {
    }

    public AttendanceLogItem(String id, int userId, ATTENDANCE_ACTION attendanceAction, LocalDateTime timestamp) {
        this.id = id;
        this.userId = userId;
        this.attendanceAction = attendanceAction;
        this.timestamp = timestamp;
    }
}

