/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.DTO.CustomerDetailsDTO;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.layout.cashierController.OrderVBox;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.config.LabelPrinterConfig;
import cz.polreich.spagetka.models.config.PrinterConfig;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LabelPrinter;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javafx.scene.image.Image;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class OrderVboxService {
    private static final Logger log = LoggerFactory.getLogger(OrderVboxService.class);
    @Autowired
    private OrderService orderService;
    Timer timer;
    private List<Order> orders = new ArrayList();
    private List<String> announcedOrders = new ArrayList();
    private HashMap<String, Boolean> showOrders = new HashMap();
    Image imageEatIn;
    Image imageTakeAway;
    Image imageDelivery;
    Image imagePickup;
    Image imageOnline;
    Image imageUnknown;
    Image imageCustomerNote;
    Image imageFirstOrder;
    Image imageNotRegistered;
    Image imageNoPhone;
    TimerTask task;
    private static final Media soundNewOrder = new Media(Objects.requireNonNull(OrderVboxService.class.getResource("/resources/sounds/level-up-191997.mp3")).toExternalForm());
    private static final MediaPlayer mediaPlayer = new MediaPlayer(soundNewOrder);
    OrderVBox orderVBox;
    CashierController cashierController;

    public OrderVBox getOrderVBox() {
        return this.orderVBox;
    }

    public void setOrderVBox(OrderVBox orderVBox) {
        this.orderVBox = orderVBox;
    }

    public OrderVboxService(CashierController cashierController) {
        try {
            this.cashierController = cashierController;
            ApplicationContext appCtx = ApplicationContextUtils.getApplicationContext();
            this.orderService = (OrderService)appCtx.getBean("orderService", OrderService.class);
            this.imageTakeAway = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/take_away_32.png"));
            this.imageEatIn = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/eat_in_32.png"));
            this.imageDelivery = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/delivery_32.png"));
            this.imagePickup = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/pickup_32.png"));
            this.imageOnline = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/globe_32.png"));
            this.imageUnknown = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/question-sign_32.png"));
            this.imageCustomerNote = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/note_red_32.png"));
            this.imageFirstOrder = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/number-1_32.png"));
            this.imageNotRegistered = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/no-account_32.png"));
            this.imageNoPhone = new Image(ResourceHelper.getImageAsStream((String)"/resources/images/no-phone_32.png"));
            this.orderVBox = new OrderVBox(this, cashierController, this.imageEatIn, this.imageTakeAway, this.imageDelivery, this.imagePickup, this.imageOnline, this.imageUnknown, this.imageCustomerNote, this.imageFirstOrder, this.imageNotRegistered, this.imageNoPhone);
            List<ORDER_STATUS> ignoredStatuses = Arrays.asList(ORDER_STATUS.DONE, ORDER_STATUS.CANCELLED, ORDER_STATUS.WAITING_FOR_PAYMENT, ORDER_STATUS.REJECTED);
            List o = this.orderService.getOrdersCreatedFrom6AmToNextDay6AmWithoutTHISOrderStatuses(ignoredStatuses);
            if (!o.isEmpty()) {
                this.fillShowOrders(this.orders);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public void startTimer() {
        this.task = new /* Unavailable Anonymous Inner Class!! */;
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(this.task, 0L, 5000L);
    }

    public void stopTimer() {
        this.timer.cancel();
    }

    private void verifyReceipts(List<Order> orders) {
        for (Order order : orders) {
            if (!PAYMENT_METHOD.ONLINE.equals((Object)order.getPaymentMethod()) && !PAYMENT_METHOD.WOLT_ONLINE.equals((Object)order.getPaymentMethod()) || !order.isTaxRelevant() || this.cashierController.receiptService.existsByOrderId(order.getId())) continue;
            this.cashierController.createReceipt(true, order);
        }
    }

    private void evaluateCustomerStatus(List<Order> orders) {
        for (Order order : orders) {
            if (order.getCustomerPhoneNumber().trim().isEmpty() || order.isCustomerEvaluated() != null && order.isCustomerEvaluated().booleanValue()) continue;
            CustomerDetailsDTO customerDetails = this.cashierController.activeConfig.getPartnerServerRestClient().getCustomerDetails(order.getCustomerPhoneNumber());
            if (customerDetails != null && customerDetails.isExists()) {
                order.setCustomerRegistered(Boolean.valueOf(customerDetails.isRegistered()));
                order.setCustomerFirstOrder(Boolean.valueOf(customerDetails.getNumberOfOrders() != null && customerDetails.getNumberOfOrders() == 0));
            }
            order.setCustomerEvaluated(Boolean.valueOf(true));
            this.orderService.update(order);
        }
    }

    private void printNotificationsOrdersPaidByCash() {
        List orders = this.orderService.getOrdersToBeFinishedFrom6AmToNextDay6AmWithTHISOrderStatus(ORDER_STATUS.WAITING_FOR_PAYMENT);
        List<Order> orderPaidByCash = orders.stream().filter(o -> o.getPaymentMethod().equals((Object)PAYMENT_METHOD.CASH)).toList();
        log.debug("Cashier - found {} orders which are waiting for payment", (Object)orderPaidByCash.size());
        List<Order> toBeAnnounced = orderPaidByCash.stream().filter(o -> !o.isAnnounced()).toList();
        log.debug("Cashier - {} orders are not announced yet and will be announced for cashier.", (Object)toBeAnnounced.size());
        if (!toBeAnnounced.isEmpty()) {
            try {
                this.announceNewOrders(toBeAnnounced);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        }
    }

    private void fillShowOrders(List<Order> orders) {
        orders.forEach(x -> this.showOrders.put(x.getId(), true));
    }

    private void announceNewOrders(List<Order> orders) {
        for (Order order : orders) {
            if (order.isAnnounced()) continue;
            this.playSoundForNewOrder();
            PrinterConfig printerConfig = this.cashierController.activeConfig.getPrinterConfig();
            ReceiptPrinter.printNewOrderNotification((Order)order, (String)printerConfig.getPrinterName(), (int)printerConfig.getCharacters(), (String)printerConfig.getCodepage());
            order.setAnnounced(Boolean.valueOf(true));
            this.orderService.update(order);
        }
    }

    private void printStickers(List<Order> orders) {
        for (Order order : orders.stream().filter(o -> o.getOrderStatus() == ORDER_STATUS.PREPARING).toList()) {
            if (order.isStickersPrinted().booleanValue()) continue;
            System.out.println("Printing stickers for: " + order.getOrderNumber());
            order.setStickersPrinted(Boolean.valueOf(true));
            this.orderService.update(order);
            LabelPrinter.printLabelsForOrder((LabelPrinterConfig)this.cashierController.activeConfig.getLabelPrinterConfig(), (Order)order);
        }
    }

    private void playSoundForNewOrder() {
        try {
            mediaPlayer.stop();
            mediaPlayer.seek(Duration.ZERO);
            mediaPlayer.play();
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public void stop() {
        this.timer.cancel();
        this.cashierController.getOrdersFlowPane().getChildren().clear();
    }

    public OrderVboxService() {
    }

    public List<Order> getOrders() {
        return this.orders;
    }
}

