/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.loading;

import cz.polreich.spagetka.CashierApp;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.loading.BaseLoadingController;
import cz.polreich.spagetka.controllers.loading.CashierLoadingController;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.ScreenResolution;
import cz.polreich.spagetka.service.internet.InternetConnectivityService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import cz.polreich.spagetka.utils.BugsnagSingleton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import org.scenicview.ScenicView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CashierLoadingController
extends BaseLoadingController
implements Initializable {
    private static final Logger log = LoggerFactory.getLogger(CashierLoadingController.class);
    @FXML
    private Label titleLabel;
    @FXML
    private VBox mainVBox;
    @FXML
    private Button startButton;
    private CashierController cashierController;
    private ScreenResolution screenResolution;
    private boolean failure = false;
    private BooleanProperty start = new SimpleBooleanProperty(true);
    String css = this.getClass().getResource("/cz/polreich/spagetka/cashier.css").toExternalForm();
    public CashierConfig activeConfig;
    private InternetConnectivityService internetConnectivityService;

    @PostConstruct
    public void init() {
        this.activeConfig = this.config.getCashier();
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.bugsnag = BugsnagSingleton.getInstance((String)"e8c5ff74682edb48da9e0f3a4cede7cb");
        ExceptionHandler globalExceptionHandler = new ExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)globalExceptionHandler);
        this.titleLabel.setText("Cashier Loading");
        this.titleLabel.setStyle("-fx-font-size: 24px");
        this.mainVBox.setSpacing(20.0);
        this.startButton.visibleProperty().bind((ObservableValue)this.start.not());
        this.startButton.setOnMouseClicked(mouseEvent -> this.runApp());
        this.startButton.setOnTouchPressed(touchEvent -> this.runApp());
    }

    public void setupScene() {
        super.setupScene();
        this.initializeApp();
    }

    public void initializeApp() {
        this.bugsnag.addToTab("location", "kioskName", this.activeConfig.getKioskName());
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        new Thread((Runnable)task).start();
    }

    private void runTaskSection(String key, String message, String imagePath, Runnable taskLogic) {
        AtomicReference taskRow = new AtomicReference();
        Platform.runLater(() -> taskRow.set(this.createLoadingEntry(key, message, imagePath)));
        try {
            taskLogic.run();
            Platform.runLater(() -> this.confirmItemSection((Pair)taskRow.get()));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            this.failure = true;
            Platform.runLater(() -> {
                this.failItemSection((Pair)taskRow.get(), e.getMessage());
                ExceptionHandler.logException((Exception)e);
            });
        }
    }

    private void confirmItemSection(Pair<HBox, TextArea> pair) {
        HBox hbox = (HBox)pair.getKey();
        TextArea textArea = (TextArea)pair.getValue();
        textArea.setText("Done");
    }

    private void failItemSection(Pair<HBox, TextArea> pair, String message) {
        HBox hbox = (HBox)pair.getKey();
        TextArea textArea = (TextArea)pair.getValue();
        textArea.setText(message);
    }

    private Pair<HBox, TextArea> createLoadingEntry(String id, String text, String imagePath) {
        InputStream is = ResourceHelper.getImageAsStream((String)imagePath);
        Image image = new Image(is);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setFitHeight(50.0);
        imageView.setFitWidth(50.0);
        Label label = new Label(text);
        label.setStyle("-fx-font-size: 16px");
        label.setAlignment(Pos.CENTER_LEFT);
        label.setMaxWidth(330.0);
        label.setMinWidth(330.0);
        label.setPadding(LayoutUtils.getInsets((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        TextArea result = new TextArea();
        result.setId(id + "_result");
        result.setWrapText(true);
        result.setEditable(false);
        result.setMaxWidth(200.0);
        result.setMinHeight(50.0);
        result.setMaxHeight(50.0);
        HBox hbox = new HBox();
        hbox.getChildren().addAll((Object[])new Node[]{imageView, label, result});
        hbox.setAlignment(Pos.CENTER);
        this.mainVBox.getChildren().add((Object)hbox);
        Pair pair = new Pair((Object)hbox, (Object)result);
        return pair;
    }

    private void runApp() {
        try {
            this.stage.close();
            ResourceBundle strings = ResourceBundle.getBundle("resources.strings.cashier", this.activeConfig.getSelectedLocale());
            FXMLLoader loader = new FXMLLoader(CashierApp.class.getResource("cashier.fxml"), strings);
            loader.setControllerFactory(arg_0 -> ((ApplicationContext)ApplicationContextUtils.getApplicationContext()).getBean(arg_0));
            Parent root = (Parent)loader.load();
            this.cashierController = (CashierController)loader.getController();
            this.cashierController.setupStage(this.stage, strings);
            this.screenResolution = this.activeConfig.getDisplayConfig().getResolution();
            Scene scene = new Scene(root, (double)this.screenResolution.getWidth(), (double)this.screenResolution.getHeight());
            scene.getStylesheets().add((Object)this.css);
            this.stage.setScene(scene);
            this.stage.setResizable(true);
            this.stage.setTitle("Spagetka BranchCheckout v0.0.1");
            if (this.activeConfig.getDisplayConfig().isFullscreen()) {
                this.stage.setFullScreen(true);
                this.stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            }
            Rectangle2D screenBounds = ((Screen)Screen.getScreens().get(this.activeConfig.getDisplayConfig().getScreenId())).getVisualBounds();
            this.stage.setX(screenBounds.getMinX());
            this.stage.setY(screenBounds.getMinY());
            this.stage.show();
            if (this.activeConfig.isOpenScenicView()) {
                ScenicView.show((Scene)scene);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    @Autowired
    public void setInternetConnectivityService(InternetConnectivityService internetConnectivityService) {
        this.internetConnectivityService = internetConnectivityService;
    }
}

