/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.Controller;
import cz.polreich.spagetka.models.config.CustomerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javax.annotation.PostConstruct;

public class CustomerBaseController
extends Controller {
    public CustomerConfig activeConfig;
    public Font titleFont;
    public Font subtitleFont;
    public Font priceLabelFont;
    public Font normalFont;
    public Font productTitleFont;
    public Font cartProductTitleFont;
    public Font cartAddItemsLabelFont;
    public Font cartQuantityLabelFont;
    public Font payByCashTextFont;
    public Font popupTitleFont;
    public Font confirmationOrderNumberFont;
    public Font welcomeMainTitleFont;
    public Font welcomeLogoTitleFont;
    public Font welcomeSubtitleFont;
    public String mainBackgroundColor;
    public String popupBackgroundColor;
    public static long lastPressTime = System.currentTimeMillis();
    protected static int resetInterval = 120;
    protected static LongProperty timeToTimeout = new SimpleLongProperty(System.currentTimeMillis() - lastPressTime);
    protected List<Popup> popups = new ArrayList();

    @PostConstruct
    public void init() {
        super.init();
        this.activeConfig = this.config.getCustomer();
    }

    public void setupScene() {
        super.setupScene();
        resetInterval = this.activeConfig.getResetIntervalSeconds();
        this.stringBundleName = "resources/strings/customer";
        this.strings = ResourceBundle.getBundle(this.stringBundleName, this.activeConfig.getSelectedLocale());
        this.stage.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            lastPressTime = System.currentTimeMillis();
        });
        this.stage.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            lastPressTime = System.currentTimeMillis();
        });
    }

    public void setupColors() {
        super.setupColors();
        this.mainBackgroundColor = this.activeConfig.getColors().getMainBackground();
        this.popupBackgroundColor = this.activeConfig.getColors().getPopupBackground();
    }

    public void setupFonts() {
        super.setupFonts();
        this.titleFont = this.setupCustomerFont("title");
        this.subtitleFont = this.setupCustomerFont("subtitle");
        this.priceLabelFont = this.setupCustomerFont("priceLabel");
        this.normalFont = this.setupCustomerFont("normal");
        this.productTitleFont = this.setupCustomerFont("productTitle");
        this.cartProductTitleFont = this.setupCustomerFont("cartProductTitle");
        this.cartAddItemsLabelFont = this.setupCustomerFont("cartAddItemsLabel");
        this.cartQuantityLabelFont = this.setupCustomerFont("cartQuantityLabel");
        this.payByCashTextFont = this.setupCustomerFont("payByCashText");
        this.popupTitleFont = this.setupCustomerFont("popupTitle");
        this.confirmationOrderNumberFont = this.setupCustomerFont("confirmationOrderNumberFont");
        this.welcomeMainTitleFont = this.setupCustomerFont("welcomeMainTitle");
        this.welcomeLogoTitleFont = this.setupCustomerFont("welcomeLogoTitle");
        this.welcomeSubtitleFont = this.setupCustomerFont("welcomeSubtitle");
    }

    public void resetToMainScene() {
        ArrayList openedPopups = new ArrayList(this.activeConfig.getOpenedPopups());
        for (Popup popup : openedPopups) {
            if (popup == null) continue;
            popup.hide();
        }
        super.resetToMainScene();
    }
}

