/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import com.bugsnag.Bugsnag;
import cz.polreich.spagetka.utils.appmetadata.AppMetadataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugsnagSingleton {
    private static final Logger log = LoggerFactory.getLogger(BugsnagSingleton.class);
    private static BugsnagSingleton single_instance = null;
    private final Bugsnag bugsnag;

    private BugsnagSingleton(String apiKey) {
        this.bugsnag = new Bugsnag(apiKey);
        String appName = AppMetadataUtil.getAppName();
        String appVersion = AppMetadataUtil.getAppVersionFull();
        log.info("appName - " + appName);
        log.info("appVersion - " + appVersion);
        if ("unknown".equals(appName) || "unknown".equals(appVersion)) {
            this.bugsnag.setReleaseStage("development");
        } else {
            this.bugsnag.setReleaseStage("production");
        }
        this.addToTab("app", "version", appVersion);
        this.addToTab("app", "name", appName);
        this.addToTab("location", "kioskId", "unknown");
    }

    public void notify(Throwable e) {
        if (this.bugsnag != null) {
            this.bugsnag.notify(e);
        }
    }

    public void addToTab(String tabName, String key, String value) {
        if (this.bugsnag != null) {
            this.bugsnag.addCallback(report -> report.addToTab(tabName, key, (Object)value));
        }
    }

    public static synchronized BugsnagSingleton createInstance(String apiKey) {
        single_instance = new BugsnagSingleton(apiKey);
        return single_instance;
    }

    public static synchronized BugsnagSingleton getInstance(String apiKey) {
        if (single_instance == null) {
            single_instance = new BugsnagSingleton(apiKey);
        }
        return single_instance;
    }

    public static synchronized BugsnagSingleton getInstance() {
        return single_instance;
    }
}

