/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.screensaver;

import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.image.Image;
import javafx.scene.media.Media;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScreensaverResourcesService {
    private static final Logger log = LoggerFactory.getLogger(ScreensaverResourcesService.class);
    private final String resourcesMediaFolder;
    private final String resourcesImageFolder;
    private List<Image> imageList = new ArrayList();
    private int imageListSize;
    private List<Media> mediaList = new ArrayList();
    private int mediaListSize;
    private final AtomicInteger currentIndexImage = new AtomicInteger(0);
    private final AtomicInteger currentIndexMedia = new AtomicInteger(0);

    @Autowired
    public ScreensaverResourcesService(Config config) {
        this.resourcesImageFolder = config.getCustomer().getScreensaverConfig().getRelativeImagePath();
        this.resourcesMediaFolder = config.getCustomer().getScreensaverConfig().getRelativeMediaPath();
    }

    @PostConstruct
    private void init() {
        this.imageList = this.loadImageList();
        this.imageListSize = this.imageList.size();
        this.mediaList = this.loadMediaList();
        this.mediaListSize = this.mediaList.size();
    }

    public Optional<Media> nextMedia() {
        if (this.mediaListSize == 0) {
            return Optional.empty();
        }
        int nextIndex = this.currentIndexMedia.getAndUpdate(i -> (i + 1) % this.mediaListSize);
        return this.getMedia(nextIndex);
    }

    public Optional<Image> nextImage() {
        if (this.imageListSize == 0) {
            return Optional.empty();
        }
        int nextIndex = this.currentIndexImage.getAndUpdate(i -> (i + 1) % this.imageListSize);
        return this.getImage(nextIndex);
    }

    private Optional<Image> getImage(int index) {
        if (index < 0 || index >= this.imageListSize) {
            return Optional.empty();
        }
        return Optional.ofNullable((Image)this.imageList.get(index));
    }

    private Optional<Media> getMedia(int index) {
        if (index < 0 || index >= this.mediaListSize) {
            log.error("Index is out of size of media list or less then 0");
            return Optional.empty();
        }
        return Optional.of((Media)this.mediaList.get(index));
    }

    private List<Image> loadImageList() {
        ArrayList<Image> imageList = new ArrayList<Image>();
        List availableImagePaths = ResourceHelper.getAvailableImagePaths((String)this.resourcesImageFolder);
        if (!availableImagePaths.isEmpty()) {
            for (String imagePath : availableImagePaths) {
                try {
                    imageList.add(new Image(ResourceHelper.getImageAsStream((String)imagePath)));
                    log.info("Created new Image with path - {}", (Object)imagePath);
                }
                catch (Exception e) {
                    ExceptionHandler.logException((Exception)e);
                    log.error("Failed to load image from path: {}", (Object)imagePath, (Object)e);
                }
            }
        }
        return imageList;
    }

    private List<Media> loadMediaList() {
        List availableImagePaths = ResourceHelper.getAvailableMediaPaths((String)this.resourcesMediaFolder);
        ArrayList<Media> mediaList = new ArrayList<Media>();
        for (String mediaPath : availableImagePaths) {
            Optional mediaOptional = ResourceHelper.getMedia((String)mediaPath);
            if (mediaOptional.isPresent()) {
                log.info("Created new Media with path - {}", (Object)mediaPath);
                mediaList.add((Media)mediaOptional.get());
                continue;
            }
            log.error("Appeared an issue in getting mp4 by path - {}", (Object)mediaPath);
        }
        return mediaList;
    }

    public int getImageListSize() {
        return this.imageListSize;
    }

    public int getMediaListSize() {
        return this.mediaListSize;
    }
}

