/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.DTO.CashManipulationItemDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.models.CashManipulationItem;
import cz.polreich.spagetka.repository.CashManipulationItemsRepository;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashManipulationItemsService {
    @Autowired
    CashManipulationItemsRepository cashManipulationItemsRepository;
    private PartnerServerRestClient partnerServerRestClient;

    public CashManipulationItemsService() {
    }

    public CashManipulationItemsService(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    public List<CashManipulationItemDTO> findAll() {
        return this.cashManipulationItemsRepository.findAll().stream().map(CashManipulationItemDTO::new).toList();
    }

    public CashManipulationItem findById(String id) {
        return (CashManipulationItem)this.cashManipulationItemsRepository.findById((Object)id).get();
    }

    public void saveAll(List<CashManipulationItem> cashManipulationItems) {
        this.cashManipulationItemsRepository.saveAll(cashManipulationItems);
    }

    public void save(CashManipulationItem cashManipulationItem) {
        this.cashManipulationItemsRepository.save((Object)cashManipulationItem);
    }

    public boolean existsById(String id) {
        return this.cashManipulationItemsRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        this.cashManipulationItemsRepository.deleteById((Object)id);
    }

    public Double getCashManipulationsForToday() {
        return this.getCashManipulationsForDate(LocalDate.now());
    }

    public Double getCashManipulationsForDate(LocalDate day) {
        LocalDateTime start = day.atStartOfDay();
        LocalDateTime end = day.plusDays(1L).atStartOfDay().minusSeconds(1L);
        List cashManipulations = this.cashManipulationItemsRepository.findCashManipulationsBetweenDates(start, end);
        return cashManipulations.stream().mapToDouble(CashManipulationItem::getAmount).sum();
    }
}

