/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.gui.panes;

import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;

public class TouchScrollPane
extends ScrollPane {
    private double scrollSensitivity = 1.0;
    private double initialMouseY;
    private double initialScrollValue;

    public TouchScrollPane() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            this.initialMouseY = event.getSceneY();
            this.initialScrollValue = this.getVvalue();
        });
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            double deltaY = this.initialMouseY - event.getSceneY();
            double height = this.getContent().getBoundsInLocal().getHeight();
            double viewportHeight = this.getViewportBounds().getHeight();
            double deltaV = deltaY * this.scrollSensitivity / (height - viewportHeight);
            this.setVvalue(Math.min(Math.max(this.initialScrollValue + deltaV, 0.0), 1.0));
        });
    }

    public double getScrollSensitivity() {
        return this.scrollSensitivity;
    }

    public void setScrollSensitivity(double scrollSensitivity) {
        this.scrollSensitivity = scrollSensitivity;
    }
}

