/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.customerMainController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.controllers.popup.customerMainController.ProductDetailPopup;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.ImageUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Window;

public class VariantSelectionPopup
extends Popup {
    private CustomerMainController customerMainController;
    private Label popupTitle = new Label();
    private FlowPane variantsFlowPane = new FlowPane();
    private AnchorPane mainAnchorPane;
    private double popupMinWidth;
    private double popupMinHeight;
    private double popupMaxWidth;
    private double popupMaxHeight;
    private Product product;
    private List<ProductVariant> variants;
    private List<ProductVariant> enabledVariants = new ArrayList();
    private CancelButton backButton = new CancelButton();
    private FlowPane firstLevelFlowPane = new FlowPane();
    private FlowPane titleFlowPane = new FlowPane();
    private double titleFlowPaneTopAnchor;

    public VariantSelectionPopup(CustomerMainController customerMainController) {
        this.customerMainController = customerMainController;
        this.popupMinWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        this.popupMinHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.9;
        this.popupMaxWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        this.popupMaxHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.9;
        double titleFlowPaneHeight = 100.0;
        this.titleFlowPaneTopAnchor = 50.0;
        this.mainAnchorPane = new AnchorPane();
        this.mainAnchorPane.getStyleClass().add((Object)"popup-main-pane");
        this.mainAnchorPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.mainAnchorPane.setMinWidth(this.popupMinWidth);
        this.mainAnchorPane.setMinHeight(this.popupMinHeight);
        this.mainAnchorPane.setMaxWidth(this.popupMaxWidth);
        this.mainAnchorPane.setMaxHeight(this.popupMaxHeight);
        this.titleFlowPane.setMaxHeight(titleFlowPaneHeight);
        AnchorPane.setTopAnchor((Node)this.titleFlowPane, (Double)this.titleFlowPaneTopAnchor);
        AnchorPane.setLeftAnchor((Node)this.titleFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.titleFlowPane, (Double)0.0);
        this.titleFlowPane.setAlignment(Pos.CENTER);
        this.popupTitle = new Label("Vyberte si druh k\u00e1vy");
        this.popupTitle.setAlignment(Pos.CENTER);
        this.popupTitle.getStyleClass().add((Object)"popup-title");
        this.popupTitle.setFont(customerMainController.popupTitleFont);
        this.titleFlowPane.getChildren().add((Object)this.popupTitle);
        this.variantsFlowPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.variantsFlowPane.setMinWidth(this.popupMinWidth);
        this.variantsFlowPane.setMaxWidth(this.popupMaxWidth);
        int gap = 20;
        this.variantsFlowPane.setHgap((double)gap);
        this.variantsFlowPane.setVgap((double)gap);
        this.variantsFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.variantsFlowPane, (Double)(this.titleFlowPaneTopAnchor + titleFlowPaneHeight));
        AnchorPane.setLeftAnchor((Node)this.variantsFlowPane, (Double)20.0);
        AnchorPane.setRightAnchor((Node)this.variantsFlowPane, (Double)20.0);
        AnchorPane.setBottomAnchor((Node)this.variantsFlowPane, (Double)200.0);
        this.firstLevelFlowPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.firstLevelFlowPane.setMinWidth(this.popupMinWidth);
        this.firstLevelFlowPane.setMaxWidth(this.popupMaxWidth);
        int gap2 = 20;
        this.firstLevelFlowPane.setHgap((double)gap2);
        this.firstLevelFlowPane.setVgap((double)gap2);
        this.firstLevelFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.firstLevelFlowPane, (Double)(this.titleFlowPaneTopAnchor + titleFlowPaneHeight));
        AnchorPane.setLeftAnchor((Node)this.firstLevelFlowPane, (Double)20.0);
        AnchorPane.setRightAnchor((Node)this.firstLevelFlowPane, (Double)20.0);
        AnchorPane.setBottomAnchor((Node)this.firstLevelFlowPane, (Double)200.0);
        this.backButton.setText("Zp\u011bt");
        this.backButton.setPrefWidth(296.0);
        this.backButton.setPrefHeight(100.0);
        this.backButton.setFont(customerMainController.titleFont);
        this.backButton.setOnMouseClicked(mouseEvent -> this.hide());
        this.backButton.setOnTouchPressed(touchEvent -> this.hide());
        AnchorPane.setLeftAnchor((Node)this.backButton, (Double)((this.popupMaxWidth - 296.0) / 2.0));
        AnchorPane.setRightAnchor((Node)this.backButton, (Double)((this.popupMaxWidth - 296.0) / 2.0));
        AnchorPane.setBottomAnchor((Node)this.backButton, (Double)30.0);
        this.mainAnchorPane.getChildren().addAll((Object[])new Node[]{this.titleFlowPane, this.firstLevelFlowPane, this.backButton});
        this.getContent().add((Object)this.mainAnchorPane);
        this.setAutoHide(false);
    }

    public void loadPopup(Product product) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.customerMainController.activeConfig.getOpenedPopups().add(this);
        this.product = product;
        System.out.println("Product: " + product.getName() + " : " + product.getId());
        this.variants = product.getProductVariants();
        System.out.println("Variants: " + this.variants.size());
        for (ProductVariant variant : this.variants) {
            System.out.println("Variant: " + variant.getName() + " : " + variant.getId());
            boolean ingredientsAvailable = true;
            for (CompositionItem item : variant.getIngredients()) {
                System.out.println("Ingredient: " + item.getIngredient().getName() + " : " + item.getIngredient().getId());
                boolean ingredientExists = this.customerMainController.stockItemService.findSoonestExpiringByIngredientId(item.getIngredient().getId(), 0.1) != null;
                System.out.println("Ingredient exists: " + ingredientExists);
                if (ingredientExists) continue;
                System.out.println("Ingredient not available: " + item.getIngredient().getName() + " : " + item.getIngredient().getId());
                ingredientsAvailable = false;
                break;
            }
            if (!variant.isEnabled() || variant.getIngredients().isEmpty() || !ingredientsAvailable) continue;
            System.out.println("Adding enabled variant: " + variant.getName() + " : " + variant.getId());
            this.enabledVariants.add(variant);
        }
        VBox chooseCoffeeButton = this.createTile("/resources/images/coffeeVariantSelect.png", "Vyberu si druh k\u00e1vy", 2);
        chooseCoffeeButton.setOnMouseClicked(mouseEvent -> this.loadVariants());
        chooseCoffeeButton.setOnTouchPressed(touchEvent -> this.loadVariants());
        Random rand = new Random();
        ArrayList enabledWithoutDecaffeinato = new ArrayList(this.enabledVariants);
        for (ProductVariant variant : this.enabledVariants) {
            System.out.println("Checking variant: " + variant.getName() + " : " + variant.getId());
            if (!variant.getName().contains("Decaffeinato")) continue;
            System.out.println("Removing decaffeinato variant: " + variant.getName() + " : " + variant.getId());
            enabledWithoutDecaffeinato.remove(variant);
        }
        System.out.println("Enabled without decaffeinato: " + enabledWithoutDecaffeinato.size());
        if (!enabledWithoutDecaffeinato.isEmpty()) {
            VBox randomCoffeeButton = this.createVariantTile((ProductVariant)enabledWithoutDecaffeinato.get(rand.nextInt(enabledWithoutDecaffeinato.size())), "/resources/images/random_coffee.png", "Nech\u00e1m se p\u0159ekvapit", 2);
            this.firstLevelFlowPane.getChildren().addAll((Object[])new Node[]{chooseCoffeeButton, randomCoffeeButton});
        } else {
            this.firstLevelFlowPane.getChildren().add((Object)chooseCoffeeButton);
        }
        this.show((Window)this.customerMainController.stage);
    }

    private void loadVariants() {
        AnchorPane.setTopAnchor((Node)this.titleFlowPane, (Double)10.0);
        this.mainAnchorPane.getChildren().remove((Object)this.firstLevelFlowPane);
        for (ProductVariant variant : this.enabledVariants) {
            VBox tile = this.createVariantTile(variant, 3);
            this.variantsFlowPane.getChildren().add((Object)tile);
        }
        this.mainAnchorPane.getChildren().add((Object)this.variantsFlowPane);
        this.backButton.setOnMouseClicked(mouseEvent -> this.switchBackToFirstLevel());
        this.backButton.setOnTouchPressed(touchEvent -> this.switchBackToFirstLevel());
    }

    private void switchBackToFirstLevel() {
        AnchorPane.setTopAnchor((Node)this.titleFlowPane, (Double)this.titleFlowPaneTopAnchor);
        this.variantsFlowPane.getChildren().removeAll((Collection)this.variantsFlowPane.getChildren());
        this.mainAnchorPane.getChildren().remove((Object)this.variantsFlowPane);
        this.mainAnchorPane.getChildren().add((Object)this.firstLevelFlowPane);
        this.backButton.setOnMouseClicked(mouseEvent -> this.hide());
        this.backButton.setOnTouchPressed(touchEvent -> this.hide());
    }

    private VBox createTile(String imagePath, String text, int tileColumns) {
        return this.createTile(imagePath, text, 0.0, tileColumns);
    }

    private VBox createTile(String imagePath, String text, double price, int tileColumns) {
        double tileWidth = this.popupMinWidth * 0.85 / (double)tileColumns;
        double tileHeight = tileWidth + 10.0;
        int tileCornerRadius = 50;
        int borderWidth = 1;
        double internalTileWidth = tileWidth - (double)(2 * borderWidth);
        double internalTileHeight = tileHeight - (double)(2 * borderWidth);
        double imageHeight = internalTileHeight * 0.6;
        double imageWidth = internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageHeight + 15.0;
        double buttonWidth = tileWidth / 3.0;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize(tileWidth, tileHeight);
        vBox.setMaxSize(tileWidth, tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-color: white;\n  -fx-background-radius: " + tileCornerRadius + "px;\n  -fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize(internalTileWidth, internalTileHeight);
        anchorPane.setMinSize(internalTileWidth, internalTileHeight);
        InputStream is = ResourceHelper.getImageAsStream((String)imagePath);
        Image fullImage = new Image(is);
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageWidth, (double)imageHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        imageView.setFitHeight(imageHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        Label nameLabel = new Label(text);
        nameLabel.setFont(this.customerMainController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.TOP_CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        if (price != 0.0) {
            Label priceLabel = new Label("+" + FormatUtils.formatCurrency((double)price, (String)this.customerMainController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.customerMainController.activeConfig.getSelectedLocale())));
            priceLabel.setFont(this.customerMainController.priceLabelFont);
            priceLabel.setWrapText(false);
            priceLabel.setAlignment(Pos.BOTTOM_RIGHT);
            AnchorPane.setBottomAnchor((Node)priceLabel, (Double)0.0);
            AnchorPane.setRightAnchor((Node)priceLabel, (Double)20.0);
            anchorPane.getChildren().add((Object)priceLabel);
        }
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    private VBox createVariantTile(ProductVariant variant, String imagePath, String text, int tileColumns) {
        VBox tile = this.createTile(imagePath, text, variant.getPrice().doubleValue(), tileColumns);
        tile.setOnMouseClicked(mouseEvent -> {
            this.hide();
            this.customerMainController.addVariantToOrder(this.product, variant);
        });
        return tile;
    }

    private VBox createVariantTile(ProductVariant variant, int tileColumns) {
        VBox tile = this.createTile(variant.getImageFilePath(), variant.getName(), variant.getPrice().doubleValue(), tileColumns);
        tile.setOnMouseClicked(mouseEvent -> {
            this.hide();
            this.customerMainController.addVariantToOrder(this.product, variant);
        });
        AnchorPane tileAnchorPane = (AnchorPane)tile.getChildren().get(0);
        Button infoButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/info_32.png");
        infoButton.setAlignment(Pos.CENTER);
        infoButton.setOnMouseClicked(mouseEvent -> {
            ProductDetailPopup detailPopup = new ProductDetailPopup(this.customerMainController);
            detailPopup.loadPopup(variant);
            mouseEvent.consume();
        });
        AnchorPane.setBottomAnchor((Node)infoButton, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)infoButton, (Double)20.0);
        tileAnchorPane.getChildren().add((Object)infoButton);
        return tile;
    }

    public void hide() {
        this.customerMainController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
        this.customerMainController.refreshVariantSelectionPopup();
    }
}

