/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class NewDeliveryOrderPopup
extends Popup {
    private AnchorPane popupAnchor = new AnchorPane();
    private FlowPane orderFlowPane = new FlowPane();
    private CashierController cashierController;
    private Map<String, VBox> orderBoxesMap = new HashMap();
    private Map<String, Label> countdownLabelsMap = new HashMap();
    private Map<String, ProgressIndicator> progressIndicatorsMap = new HashMap();
    private ObservableList<Order> relevantOrders = FXCollections.observableArrayList();

    public NewDeliveryOrderPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 700;
        int popupHeight = 700;
        AnchorPane.setTopAnchor((Node)this.orderFlowPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.orderFlowPane, (Double)25.0);
        AnchorPane.setRightAnchor((Node)this.orderFlowPane, (Double)25.0);
        AnchorPane.setBottomAnchor((Node)this.orderFlowPane, (Double)100.0);
        this.popupAnchor.getChildren().add((Object)this.orderFlowPane);
        this.popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        Label titleLabel = new Label("Nov\u00e1 objedn\u00e1vka rozvozu");
        titleLabel.setFont(cashierController.titleFont);
        this.popupAnchor.getChildren().add((Object)titleLabel);
        this.relevantOrders.addListener(change -> Platform.runLater(() -> this.updateOrders(this.relevantOrders)));
        this.orderFlowPane.setVgap(20.0);
        this.getContent().add((Object)this.popupAnchor);
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        this.relevantOrders.setAll(this.cashierController.orderVboxService.getOrders().stream().filter(order -> order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)).toList());
    }

    private void updateOrders(ObservableList<Order> relevantOrders) {
        this.orderFlowPane.getChildren().clear();
        relevantOrders = relevantOrders.filtered(order -> order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT));
        if (relevantOrders.isEmpty()) {
            this.hidePopup();
            return;
        }
        for (String orderId : this.orderBoxesMap.keySet()) {
            if (!relevantOrders.stream().noneMatch(order -> order.getId().equals(orderId))) continue;
            this.resolveOrder(orderId);
        }
        for (Order order2 : relevantOrders) {
            String orderId = order2.getId();
            if (!this.orderBoxesMap.containsKey(orderId)) {
                this.createOrderVBox(order2);
            }
            this.orderFlowPane.getChildren().add((Object)((Node)this.orderBoxesMap.get(orderId)));
        }
    }

    private void createOrderVBox(Order order) {
        String orderId = order.getId();
        VBox orderVBox = new VBox();
        HBox headerHBox = new HBox();
        orderVBox.setPrefWidth(650.0);
        orderVBox.setPrefHeight(100.0);
        orderVBox.getStyleClass().add((Object)"orderVBox");
        Label label = new Label("\u010c. obj.: " + order.getOrderNumber());
        Label countdownLabel = new Label();
        Label priceLabel = new Label("Cena: " + FormatUtils.formatCurrency((double)order.getTotalPrice(), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale())));
        ProgressIndicator progressIndicator = new ProgressIndicator(1.0);
        progressIndicator.setStyle(".percentage { visibility: hidden; }.text { visibility: hidden; }");
        headerHBox.getChildren().addAll((Object[])new Node[]{label});
        VBox orderItemsVBox = new VBox();
        for (OrderItem orderItem : order.getOrderItems()) {
            HBox orderItemsHBox = LayoutUtils.createOrderItemsList((OrderItem)orderItem, (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()));
            orderItemsVBox.getChildren().add((Object)orderItemsHBox);
        }
        HBox buttonsHBox = new HBox();
        buttonsHBox.getStyleClass().add((Object)"buttonsHBox");
        ConfirmButton acceptButton = new ConfirmButton("P\u0159ijmout");
        acceptButton.setOnMouseClicked(event -> Platform.runLater(() -> {
            this.acceptOrder(order);
            this.resolveOrder(orderId);
            buttonsHBox.setVisible(false);
        }));
        CancelButton rejectButton = new CancelButton("Odm\u00edtnout");
        rejectButton.setOnMouseClicked(event -> Platform.runLater(() -> {
            this.rejectOrder(order);
            this.resolveOrder(orderId);
            buttonsHBox.setVisible(false);
        }));
        buttonsHBox.setSpacing(20.0);
        buttonsHBox.getChildren().addAll((Object[])new Node[]{progressIndicator, countdownLabel, acceptButton, rejectButton});
        orderVBox.setSpacing(10.0);
        orderVBox.getChildren().addAll((Object[])new Node[]{headerHBox, priceLabel, orderItemsVBox, buttonsHBox});
        this.orderBoxesMap.put(orderId, orderVBox);
        this.countdownLabelsMap.put(orderId, countdownLabel);
        this.progressIndicatorsMap.put(orderId, progressIndicator);
        this.startCountdown(order.getExpectedResponseTime(), countdownLabel, progressIndicator, order);
    }

    private void startCountdown(LocalDateTime expectedResponseTime, Label countdownLabel, ProgressIndicator progressIndicator, Order order) {
        int totalDuration = (int)this.getRemainingSeconds(expectedResponseTime);
        AtomicReference<Timeline> timelineRef = new AtomicReference<Timeline>();
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), event -> {
            long remainingSeconds = this.getRemainingSeconds(expectedResponseTime);
            if (remainingSeconds <= 0L) {
                countdownLabel.setText("Time's up!");
                progressIndicator.setProgress(0.0);
                if (order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)) {
                    this.resolveOrder(order.getId());
                    this.acceptOrder(order);
                }
                ((Timeline)timelineRef.get()).stop();
            } else {
                countdownLabel.setText(remainingSeconds + "s");
                progressIndicator.setProgress((double)remainingSeconds / (double)totalDuration);
            }
        }, new KeyValue[0])});
        timelineRef.set(timeline);
        timeline.setCycleCount(-1);
        timeline.play();
    }

    private void resolveOrder(String orderId) {
        this.orderFlowPane.getChildren().remove(this.orderBoxesMap.get(orderId));
        this.removeOrderFromMaps(orderId);
        this.relevantOrders.removeIf(order -> order.getId().equals(orderId));
    }

    private void removeOrderFromMaps(String orderId) {
        this.orderBoxesMap.remove(orderId);
        this.countdownLabelsMap.remove(orderId);
        this.progressIndicatorsMap.remove(orderId);
    }

    private void acceptOrder(Order order) {
        order.setOrderStatus(ORDER_STATUS.CONFIRMED);
        this.cashierController.orderService.update(order);
    }

    private void rejectOrder(Order order) {
        order.setOrderStatus(ORDER_STATUS.REJECTED);
        this.cashierController.orderService.update(order);
    }

    private long getRemainingSeconds(LocalDateTime expectedResponseTime) {
        LocalDateTime expiryTime = expectedResponseTime.minusSeconds(1L);
        return Math.max(0L, ChronoUnit.SECONDS.between(LocalDateTime.now(), expiryTime));
    }

    public void hidePopup() {
        this.hide();
    }
}

