/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.CashierBaseController;
import cz.polreich.spagetka.controllers.popup.ModalPopup;
import cz.polreich.spagetka.controllers.popup.orderManagementController.CancelOrderPopup;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.config.LabelPrinterConfig;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.models.gui.buttons.WoltButton;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ReceiptService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LabelPrinter;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderManagementController
extends CashierBaseController
implements Initializable {
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private Button cashPaymentConfirmationButton;
    @FXML
    private Button exitButton;
    @FXML
    private Button findOrderButton;
    @FXML
    private Button cancelOrderButton;
    @FXML
    private Button cookOrderButton;
    @FXML
    private Button printReceiptButton;
    @FXML
    private Button printLabelsButton;
    @FXML
    private Label titleLabel;
    @FXML
    private TextField orderNumberTextField;
    @FXML
    private TextField orderIdTextField;
    @FXML
    private FlowPane orderInfoFlowPane;
    @FXML
    private GridPane orderInfoGridPane;
    @FXML
    private GridPane orderItemsInfoGridPane;
    @FXML
    private Label cancelTextLabel;
    @FXML
    private AnchorPane cancelOrderAnchorPane;
    @FXML
    private Button cancelCancelOrderButton;
    @FXML
    private Button acceptCancelOrderButton;
    @FXML
    private FlowPane buttonsFlowPane;
    @FXML
    private ScrollPane orderInfoScrollPane;
    @FXML
    private TextField selectedTextField;
    @FXML
    private FlowPane keyboardFlowPane;
    private HBox orderInfoHBox = new HBox();
    public BooleanProperty orderLoaded = new SimpleBooleanProperty(false);
    @Autowired
    public OrderService orderService;
    @Autowired
    public ReceiptService receiptService;
    ObjectProperty<Order> orderObjectProperty = new SimpleObjectProperty();
    StringProperty loadedOrderId = new SimpleStringProperty(null);
    private CancelOrderPopup cancelOrderPopup;
    StringBuilder outputScan = new StringBuilder();

    private Order getOrder() {
        return (Order)this.orderObjectProperty.get();
    }

    private void setOrder(Order order) {
        this.orderObjectProperty.set((Object)order);
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
    }

    public void loadOrderByOrderNumber(String orderNumber) {
        this.setOrder(this.orderService.findByOrderNumberByToday(orderNumber));
    }

    public void loadOrderById(String orderId) {
        this.setOrder(this.orderService.findById(orderId));
    }

    public void setupScene() {
        Platform.runLater(() -> this.mainAnchorPane.requestFocus());
        this.mainAnchorPane.setOnKeyPressed(arg_0 -> this.handleKeyPress(arg_0));
        super.setupScene();
        this.initButtons();
        this.cancelOrderPopup = new CancelOrderPopup(this);
        this.orderInfoGridPane.setHgap(25.0);
        this.orderItemsInfoGridPane.setHgap(10.0);
        this.cancelOrderAnchorPane.setStyle("-fx-background-color: black");
        this.cancelOrderAnchorPane.setVisible(false);
        this.titleLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.orderLoaded.get() ? "Objednavka cislo: " + this.getOrder().getOrderNumber() : "Vyhledejte objednavku", (Observable[])new Observable[]{this.orderLoaded, this.orderObjectProperty}));
        this.orderNumberTextField.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderIdTextField.getText().isEmpty(), (Observable[])new Observable[]{this.orderIdTextField.textProperty()}));
        this.orderIdTextField.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderNumberTextField.getText().isEmpty(), (Observable[])new Observable[]{this.orderNumberTextField.textProperty()}));
        this.findOrderButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.orderNumberTextField.getText().isEmpty(), (Observable[])new Observable[]{this.orderNumberTextField.textProperty()}).and((ObservableBooleanValue)Bindings.createBooleanBinding(() -> this.orderIdTextField.getText().isEmpty(), (Observable[])new Observable[]{this.orderIdTextField.textProperty()})));
        this.selectedTextField = this.orderNumberTextField;
        this.orderNumberTextField.setFocusTraversable(false);
        this.orderNumberTextField.setFont(this.subtitleFont);
        this.orderNumberTextField.getProperties().put((Object)"vkType", (Object)"none");
        this.orderNumberTextField.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            this.selectedTextField = this.orderNumberTextField;
        });
        this.orderIdTextField.setFocusTraversable(false);
        this.orderIdTextField.setFont(this.subtitleFont);
        this.orderIdTextField.getProperties().put((Object)"vkType", (Object)"none");
        this.orderIdTextField.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            this.selectedTextField = this.orderIdTextField;
        });
        this.keyboardFlowPane.setAlignment(Pos.CENTER);
        GridPane keyboardGridPane = this.createNumberKeyboard();
        this.keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        this.createOrderExistBinding();
    }

    private void handleKeyPress(KeyEvent event) {
        KeyCode code = event.getCode();
        if (code.getName().equalsIgnoreCase("tab")) {
            Order order;
            if (!this.outputScan.isEmpty() && (order = this.orderService.findByIdQuery(this.outputScan.toString())) != null) {
                this.setOrder(order);
            }
            this.outputScan.setLength(0);
            Platform.runLater(() -> this.mainAnchorPane.requestFocus());
        } else {
            this.outputScan.append(event.getText());
        }
    }

    private void initButtons() {
        this.exitButton.setFont(this.orderManagementActionButtonsFont);
        for (Node node : this.buttonsFlowPane.getChildren()) {
            if (!(node instanceof Button)) continue;
            Button button = (Button)node;
            button.setFont(this.orderManagementActionButtonsFont);
            button.setPrefHeight(100.0);
            button.setMaxHeight(100.0);
            button.setPrefWidth(250.0);
            button.setPrefWidth(250.0);
        }
    }

    private GridPane createNumberKeyboard() {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = (GrayButton)this.createKeyboardButton((Button)new GrayButton(), String.valueOf(i2));
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = (GrayButton)this.createKeyboardButton((Button)new GrayButton(), String.valueOf(0));
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = (GrayButton)this.createKeyboardButton((Button)new GrayButton(), "x");
        buttonBackSpace.setGraphic((Node)ResourceHelper.getImageViewFromResourceName((String)"/resources/images/backspace_64.png"));
        WoltButton woltButton = (WoltButton)this.createKeyboardButton((Button)new WoltButton(), "W");
        woltButton.setText("W");
        gridPane.add((Node)woltButton, 4, 0);
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    private <T extends Button> T createKeyboardButton(T button, String label) {
        button.setId("keyboard_" + label);
        button.setFont(this.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.number_keyboard_clicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.number_keyboard_clicked(arg_0));
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin(button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void number_keyboard_clicked(Event e) {
        String buttonId = ((Button)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.selectedTextField.getText().isEmpty()) {
                int toDelete = 1;
                this.selectedTextField.setText(this.selectedTextField.getText().substring(0, this.selectedTextField.getText().length() - toDelete));
            }
        } else {
            this.selectedTextField.setText(this.selectedTextField.getText() + number);
        }
    }

    @FXML
    public void cashPaymentConfirmationButtonAction() {
        if (this.getOrder() != null) {
            this.confirmOrderPaid();
            this.setOrder(this.orderService.findByIdQuery((String)this.loadedOrderId.get()));
        }
    }

    @FXML
    public void exitButtonAction() {
        System.out.println("EXIT");
        this.switchToCashierScene(this.config);
    }

    @FXML
    public void findOrderButtonAction() {
        if (!this.orderNumberTextField.getText().isEmpty()) {
            this.setOrder(this.orderService.findByOrderNumberByToday(this.orderNumberTextField.getText()));
        } else {
            this.setOrder(this.orderService.findByIdQuery(this.orderIdTextField.getText()));
        }
    }

    @FXML
    public void cancelOrderButtonAction() {
        if (this.getOrder().getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PAYMENT)) {
            this.cancelOrderAnchorPane.setVisible(true);
            this.cancelTextLabel.setText("Opravdu chcete zru\u0161it tuto objedn\u00e1vku?");
        } else if (this.getOrder().getOrderStatus().equals((Object)ORDER_STATUS.CONFIRMED) || this.getOrder().getOrderStatus().equals((Object)ORDER_STATUS.PREPARING) || this.getOrder().getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PICKUP) || this.getOrder().getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_DELIVERY) || this.getOrder().getOrderStatus().equals((Object)ORDER_STATUS.DONE)) {
            List receipts = this.receiptService.findAllByOrderId(this.getOrder().getId());
            if (!receipts.isEmpty()) {
                this.cancelOrderPopup.loadPopup(this.getOrder(), receipts);
            } else {
                this.cancelOrderAnchorPane.setVisible(true);
                this.cancelTextLabel.setText("Opravdu chcete zru\u0161it tuto objedn\u00e1vku?");
            }
        }
    }

    @FXML
    public void acceptCancelOrderButtonAction() {
        this.getOrder().setOrderStatus(ORDER_STATUS.CANCELLED);
        this.orderService.update(this.getOrder());
        this.cancelOrderAnchorPane.setVisible(false);
        this.setOrder(this.orderService.findByIdQuery((String)this.loadedOrderId.get()));
    }

    @FXML
    public void cancelCancelOrderButtonAction() {
        this.cancelOrderAnchorPane.setVisible(false);
    }

    @FXML
    public void cookOrderButtonAction() {
        this.getOrder().setOrderStatus(ORDER_STATUS.PREPARING);
        this.orderService.update(this.getOrder());
        this.setOrder(this.orderService.findByIdQuery((String)this.loadedOrderId.get()));
    }

    @FXML
    public void printReceiptButtonAction() {
        if (this.receiptService.existsByOrderId((String)this.loadedOrderId.get())) {
            Receipt receipt = this.receiptService.findByOrderIdOnlyPositive((String)this.loadedOrderId.get());
            if (receipt != null) {
                this.printReceipt(receipt);
            }
        } else if (this.getOrder().getOrderStatus() == ORDER_STATUS.CANCELLED) {
            ModalPopup confirmationPopup = new ModalPopup("Tato objedn\u00e1vka je zru\u0161ena a nem\u00e1 vytvo\u0159enou \u00fa\u010dtenku. Opravdu chcete vytvo\u0159it novou \u00fa\u010dtenku pro zru\u0161enou objedn\u00e1vku?", this.subtitleFont, "Vytvo\u0159it", "Nevytv\u00e1\u0159et", this.titleFont, 600.0, 400.0, confirmed -> {
                if (confirmed.booleanValue()) {
                    this.createReceipt(true);
                }
            });
            confirmationPopup.show((Window)this.stage);
        } else {
            this.createReceipt(true);
        }
    }

    @FXML
    public void printLabelsButtonAction() {
        LabelPrinter.printLabelsForOrder((LabelPrinterConfig)this.activeConfig.getLabelPrinterConfig(), (Order)this.getOrder());
    }

    private void showButtons(boolean show) {
        this.cashPaymentConfirmationButton.setVisible(show);
        this.cancelOrderButton.setVisible(show);
        this.cookOrderButton.setVisible(show);
    }

    private void createOrderExistBinding() {
        this.orderLoaded.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.getOrder() != null, (Observable[])new Observable[]{this.orderObjectProperty}));
        this.loadedOrderId.bind((ObservableValue)Bindings.createStringBinding(() -> this.getOrder() != null ? this.getOrder().getId() : null, (Observable[])new Observable[]{this.orderObjectProperty}));
        this.cashPaymentConfirmationButton.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.cancelOrderButton.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.cookOrderButton.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.printReceiptButton.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.printLabelsButton.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.cashPaymentConfirmationButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderLoaded.get() || !this.getOrder().canBeConfirmed(), (Observable[])new Observable[]{this.orderLoaded, this.orderObjectProperty}));
        this.cancelOrderButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderLoaded.get() || !this.getOrder().canBeCancelled() || !this.getOrder().isTaxRelevant(), (Observable[])new Observable[]{this.orderLoaded, this.orderObjectProperty}));
        this.cookOrderButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderLoaded.get() || !this.getOrder().canBePrepared(), (Observable[])new Observable[]{this.orderLoaded, this.orderObjectProperty}));
        this.printReceiptButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderLoaded.get() || !this.getOrder().isPaid() || !this.getOrder().isTaxRelevant(), (Observable[])new Observable[]{this.orderLoaded, this.orderObjectProperty}));
        this.printLabelsButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.orderLoaded.get() || !this.getOrder().isPaid() || this.activeConfig.getLabelPrinterConfig() == null || !this.activeConfig.getLabelPrinterConfig().isEnabled(), (Observable[])new Observable[]{this.orderLoaded, this.orderObjectProperty}));
        this.findOrderButton.visibleProperty().bind((ObservableValue)this.orderLoaded.not());
        this.keyboardFlowPane.visibleProperty().bind((ObservableValue)this.orderLoaded.not());
        this.orderIdTextField.visibleProperty().bind((ObservableValue)this.orderLoaded.not());
        this.orderNumberTextField.visibleProperty().bind((ObservableValue)this.orderLoaded.not());
        this.orderInfoFlowPane.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.orderInfoScrollPane.widthProperty().addListener((obs, oldVal, newVal) -> this.orderInfoFlowPane.setPrefWidth(((Double)newVal).doubleValue()));
        this.orderInfoGridPane.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.orderItemsInfoGridPane.visibleProperty().bind((ObservableValue)this.orderLoaded);
        this.orderObjectProperty.addListener((observableValue, oldValue, newValue) -> {
            Separator separator;
            this.orderInfoGridPane.getChildren().removeAll((Collection)this.orderInfoGridPane.getChildren());
            int rowNumber = 0;
            for (Field field : Order.class.getDeclaredFields()) {
                boolean originalAccessibility = field.canAccess(newValue);
                try {
                    field.setAccessible(true);
                    if (field.getName().equals("orderItems") || field.getName().equals("announced") || field.getName().startsWith("user") || field.getName().equals("customerId") || field.getName().equals("expectedResponseTime") || field.getName().equals("cleanOrderNumber") || field.getName().equals("stickersPrinted") || field.getName().equals("customerRegistered") || field.getName().equals("customerFirstOrder") || field.getName().equals("customerEvaluated")) continue;
                    String textKey = field.getName();
                    try {
                        textKey = this.strings.getString("order." + field.getName());
                    }
                    catch (Exception e) {
                        ExceptionHandler.logException((Exception)e);
                    }
                    String textValue = this.translateOrderValue(newValue, field);
                    Label labelKey = this.getTableLabel(textKey, this.orderInfoGridPane.getMaxWidth() * 0.33);
                    Label labelValue = this.getTableLabel(textValue, this.orderInfoGridPane.getMaxWidth() * 0.66);
                    this.orderInfoGridPane.addRow(rowNumber, new Node[]{labelKey, labelValue});
                    separator = new Separator(Orientation.HORIZONTAL);
                    separator.setPrefHeight(2.0);
                    separator.setPrefWidth(this.orderInfoGridPane.getMaxWidth());
                    this.orderInfoGridPane.getRowConstraints().add(rowNumber, (Object)new RowConstraints(-1.0));
                    GridPane.setConstraints((Node)separator, (int)0, (int)(rowNumber + 1));
                    GridPane.setColumnSpan((Node)separator, (Integer)2);
                    this.orderInfoGridPane.getRowConstraints().add(rowNumber + 1, (Object)new RowConstraints(-1.0));
                    this.orderInfoGridPane.getChildren().add((Object)separator);
                    rowNumber += 2;
                }
                catch (IllegalAccessException e) {
                    ExceptionHandler.logException((Exception)e);
                }
                finally {
                    field.setAccessible(originalAccessibility);
                }
            }
            if (PAYMENT_METHOD.CASH.equals((Object)this.getOrder().getPaymentMethod())) {
                BigDecimal rounded = BigDecimal.valueOf(Math.round(this.getOrder().getTotalPrice())).setScale(2, RoundingMode.HALF_UP);
                double totalAmountAfterRounding = rounded.doubleValue();
                double rounding = totalAmountAfterRounding - this.getOrder().getTotalPrice();
                Label roundingText = this.getTableLabel("Zaokrouhlen\u00ed", this.orderInfoGridPane.getMaxWidth() * 0.33);
                Label roundingValue = this.getTableLabel(FormatUtils.formatCurrency((double)rounding, (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())), this.orderInfoGridPane.getMaxWidth() * 0.66);
                Label toPayText = this.getTableLabel("K platb\u011b", this.orderInfoGridPane.getMaxWidth() * 0.33, 25);
                Label toPayValue = this.getTableLabel(FormatUtils.formatCurrency((double)totalAmountAfterRounding, (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())), this.orderInfoGridPane.getMaxWidth() * 0.66, 25);
                this.orderInfoGridPane.addRow(rowNumber, new Node[]{roundingText, roundingValue});
                separator = new Separator(Orientation.HORIZONTAL);
                separator.setPrefHeight(2.0);
                separator.setPrefWidth(this.orderInfoGridPane.getMaxWidth());
                GridPane.setConstraints((Node)separator, (int)0, (int)(rowNumber + 1));
                GridPane.setColumnSpan((Node)separator, (Integer)2);
                this.orderInfoGridPane.getChildren().add((Object)separator);
                this.orderInfoGridPane.addRow(rowNumber += 2, new Node[]{toPayText, toPayValue});
                Separator separator2 = new Separator(Orientation.HORIZONTAL);
                separator2.setPrefHeight(2.0);
                separator2.setPrefWidth(this.orderInfoGridPane.getMaxWidth());
                GridPane.setConstraints((Node)separator2, (int)0, (int)(rowNumber + 1));
                GridPane.setColumnSpan((Node)separator2, (Integer)2);
                this.orderInfoGridPane.getChildren().add((Object)separator2);
            }
            this.orderItemsInfoGridPane.getChildren().removeAll((Collection)this.orderItemsInfoGridPane.getChildren());
            rowNumber = 0;
            for (OrderItem orderItem : this.getOrder().getOrderItems()) {
                Object orderItemName = orderItem.getDisplayName();
                for (Product addProduct : orderItem.getAdditionalProducts()) {
                    orderItemName = (String)orderItemName + "\n   - " + addProduct.getName();
                }
                for (ProductFreeVariant freeVariant : orderItem.getFreeVariants()) {
                    orderItemName = (String)orderItemName + "\n   - " + freeVariant.getName();
                }
                this.orderItemsInfoGridPane.addRow(rowNumber, new Node[]{this.getTableLabel((String)orderItemName, this.orderItemsInfoGridPane.getMaxWidth() * 0.65), this.getTableLabel(FormatUtils.getQuantityLabel((int)orderItem.getQuantity()), this.orderItemsInfoGridPane.getMaxWidth() * 0.2), this.getTableLabel(FormatUtils.formatCurrency((double)orderItem.getFinalPrice(), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())), this.orderItemsInfoGridPane.getMaxWidth() * 0.15)});
                Separator separator2 = new Separator(Orientation.HORIZONTAL);
                separator2.setPrefHeight(2.0);
                separator2.setPrefWidth(this.orderItemsInfoGridPane.getMaxWidth());
                GridPane.setConstraints((Node)separator2, (int)0, (int)(rowNumber + 1));
                GridPane.setColumnSpan((Node)separator2, (Integer)3);
                this.orderItemsInfoGridPane.getChildren().add((Object)separator2);
                rowNumber += 2;
            }
        });
    }

    private Label getTableLabel(String text, int fontSize) {
        Label label = new Label(text);
        label.setTextFill((Paint)Color.WHITE);
        label.setWrapText(true);
        label.setAlignment(Pos.CENTER_LEFT);
        label.setStyle("-fx-font-size: " + fontSize + ";");
        return label;
    }

    private Label getTableLabel(String text, double maxWidth) {
        return this.getTableLabel(text, maxWidth, 17);
    }

    private Label getTableLabel(String text, double maxWidth, int fontSize) {
        Label label = this.getTableLabel(text, fontSize);
        label.setMaxWidth(maxWidth);
        return label;
    }

    private String translateOrderValue(Order order, Field field) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        Object fieldValue = field.get(order);
        if (fieldValue != null) {
            if (fieldType.isEnum()) {
                return this.strings.getString(fieldType.getSimpleName() + "." + fieldValue);
            }
            if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                return String.valueOf(fieldValue);
            }
            if (fieldType.equals(String.class)) {
                return (String)fieldValue;
            }
            if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                return FormatUtils.formatCurrency((double)((Double)fieldValue), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale()));
            }
            if (fieldType.equals(LocalDateTime.class)) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss", this.activeConfig.getKioskInfo().getLanguage());
                return ((LocalDateTime)fieldValue).format(formatter);
            }
            if (fieldType.equals(DoubleProperty.class) || fieldType.equals(SimpleDoubleProperty.class)) {
                if (field.getName().toLowerCase().contains("percentage")) {
                    return FormatUtils.formatCurrency((double)((DoubleProperty)fieldValue).get(), (String)"%");
                }
                return FormatUtils.formatCurrency((double)((DoubleProperty)fieldValue).get(), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale()));
            }
            if (fieldType.equals(StringProperty.class) || fieldType.equals(SimpleStringProperty.class)) {
                String value = (String)((StringProperty)fieldValue).get();
                return value != null && !value.isEmpty() ? value : "<pr\u00e1zdn\u00e9>";
            }
            return fieldValue.toString();
        }
        return "<pr\u00e1zdn\u00e9>";
    }

    private void confirmOrderPaid() {
        this.getOrder().setOrderStatus(ORDER_STATUS.CONFIRMED);
        this.getOrder().setUserConfirmed((User)this.activeConfig.getLoggedInCashier().get());
        this.createReceipt(this.activeConfig.getPrinterConfig().isEnabled());
        if (this.activeConfig.getCurrentOrder().isDiscountApplied() && this.activeConfig.getCurrentOrder().getDiscountCode() != null) {
            this.activeConfig.getPartnerServerRestClient().notifyAboutDiscountCodeUsage(this.activeConfig.getCurrentOrder().getDiscountCode(), this.getOrder().getId());
        }
        this.orderService.update(this.getOrder());
    }

    public void printOrderNumber(Order order, boolean printHeader, boolean cutAfterPrint) {
        String printerName = this.activeConfig.getPrinterConfig().getPrinterName();
        ArrayList header = printHeader ? this.activeConfig.getKioskInfo().getReceiptInfo().getHeader() : new ArrayList();
        String logoImageName = this.activeConfig.getPrinterConfig().getLogoImageName();
        int characters = this.activeConfig.getPrinterConfig().getCharacters();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        byte[] orderNumberData = ReceiptPrinter.getOrderNumberBytes((Order)order, header, (KioskInfo)this.activeConfig.getKioskInfo(), (String)logoImageName, (boolean)cutAfterPrint, (int)characters, (String)encoding);
        ReceiptPrinter.printOrderNumber((byte[])orderNumberData, (String)printerName);
    }

    public Receipt createReceipt(boolean print) {
        Order order = this.getOrder();
        return this.createReceipt(print, order);
    }

    public Receipt createReceipt(boolean print, Order order) {
        Receipt receipt = new Receipt(order, Integer.valueOf(((User)this.activeConfig.getLoggedInCashier().get()).getId()));
        receipt.setLocation(this.activeConfig.getKioskName() + " (" + this.activeConfig.getKioskInfo().getKioskId() + ")");
        List header = this.activeConfig.getKioskInfo().getReceiptInfo().getHeader();
        String footer = this.activeConfig.getKioskInfo().getReceiptInfo().getFooter();
        receipt.setHeader(header);
        receipt.setFooter(footer);
        this.receiptService.save(receipt);
        if (print) {
            try {
                this.printReceipt(receipt);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        }
        return receipt;
    }

    public void printReceipt(Receipt receipt) {
        String printerName = this.activeConfig.getPrinterConfig().getPrinterName();
        String logoImageName = this.activeConfig.getPrinterConfig().getLogoImageName();
        int characters = this.activeConfig.getPrinterConfig().getCharacters();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        ReceiptPrinter.printReceipt((Receipt)receipt, (String)printerName, (KioskInfo)this.activeConfig.getKioskInfo(), (String)logoImageName, (int)characters, (String)encoding, (byte[])new byte[0]);
    }

    public void hideCancelOrderPopup() {
        this.cancelOrderPopup.hide();
        this.cancelOrderPopup = new CancelOrderPopup(this);
    }

    public void finishCancelReceiptCreation() {
        this.hideCancelOrderPopup();
        this.switchToOrderManagementSceneWithOrder(this.config, this.getOrder().getId());
    }
}

