/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeVerifyResponse;
import cz.polreich.spagetka.MDBController;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.ChoosePaymentPopup;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.ConfirmationPopup;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.CustomerLoginPopup;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.EnterDiscountCodePopup;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.LoadDiscountCodePopup;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.PhoneConfirmationPopup;
import cz.polreich.spagetka.models.DiscountCode;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.config.MDBConfig;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.YellowButton;
import cz.polreich.spagetka.models.gui.panes.TouchScrollPane;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ReceiptService;
import cz.polreich.spagetka.service.internet.InternetConnectivityService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ThreadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CustomerOrderConfirmationController
extends CustomerBaseController
implements Initializable {
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private AnchorPane titleAnchorPane;
    @FXML
    private Label titleLabel;
    @FXML
    private AnchorPane listOfProductsAnchorPane;
    @FXML
    private TouchScrollPane listOfProductsScrollPane;
    @FXML
    private FlowPane footerButtonsFlowPane;
    @FXML
    private AnchorPane amountAnchorPane;
    @FXML
    private Label amountNumberLabel;
    @FXML
    private Label amountLabel;
    @FXML
    private FlowPane listOfProductsVBox;
    @FXML
    private CancelButton backButton;
    @FXML
    private YellowButton discountButton;
    @FXML
    private ConfirmButton payButton;
    @FXML
    private Region beforeSpacer;
    @FXML
    private Label customerLoginLabel;
    @FXML
    private YellowButton customerLoginButton;
    @FXML
    private Label customerPhoneNumber;
    @FXML
    private FlowPane customerLoginFlowPane;
    @FXML
    private AnchorPane outerPane;
    @FXML
    private Label discountLabel;
    @FXML
    private Label discountAmountLabel;
    private Button customerLogOutButton;
    private Label emptyCartLabel = new Label();
    private ImageView emptyCartImageView;
    private ChangeListener<ObservableList<OrderItem>> cartUpdateListener;
    @Autowired
    public OrderService orderService;
    @Autowired
    private ReceiptService receiptService;
    private boolean cardPaymentSuccessful = false;
    public ChoosePaymentPopup choosePaymentPopup;
    private ConfirmationPopup confirmationPopup;
    private EnterDiscountCodePopup enterDiscountCodePopup;
    private LoadDiscountCodePopup loadDiscountCodePopup;
    private CustomerLoginPopup customerLoginPopup;
    private PhoneConfirmationPopup phoneConfirmationPopup;
    public BooleanProperty isPopupOpen = new SimpleBooleanProperty(false);
    public BooleanProperty customerLoggedIn = new SimpleBooleanProperty(false);
    @Autowired
    private PartnerServerRestClient partnerServerRestClient;
    @Autowired
    private InternetConnectivityService internetConnectivityService;

    public void initialize(URL url, ResourceBundle resourceBundle) {
    }

    public void setupScene() {
        super.setupScene();
        this.bindStrings();
        this.setupPopups();
        this.setupPanes();
        this.setupLabels();
        this.setupCart();
        this.setupButtons();
        this.startResetThread();
    }

    private void bindStrings() {
        this.bindStringToLocale(this.titleLabel, "confirmation.label.title", this.titleFont);
        this.bindStringToLocale(this.amountLabel, "confirmation.label.total", this.subtitleFont);
        this.bindStringToLocale(this.customerLoginLabel, "confirmation.label.loyaltyClub", this.titleFont);
        this.bindStringToLocale((Button)this.customerLoginButton, "confirmation.button.signin", this.titleFont);
        this.bindStringToLocale((Button)this.backButton, "confirmation.button.back", this.titleFont);
        this.bindStringToLocale((Button)this.discountButton, "confirmation.button.discountCode", this.titleFont);
        this.bindStringToLocale((Button)this.payButton, "confirmation.button.pay", this.titleFont);
        this.bindStringToLocale(this.discountLabel, "confirmation.label.discount", this.subtitleFont);
        this.bindStringToLocale(this.emptyCartLabel, "confirmation.label.emptyCart", this.titleFont);
    }

    private void startResetThread() {
        Thread existingThread = ThreadUtils.getThreadByName((String)"ResetThreadCustomerConfirmation");
        if (existingThread == null || !existingThread.isAlive()) {
            if (existingThread != null) {
                existingThread.interrupt();
            }
            Thread taskThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            taskThread.setName("ResetThreadCustomerConfirmation");
            taskThread.setDaemon(true);
            taskThread.start();
        }
    }

    private void setupPopups() {
        this.choosePaymentPopup = new ChoosePaymentPopup(this);
        this.confirmationPopup = new ConfirmationPopup(this);
        this.enterDiscountCodePopup = new EnterDiscountCodePopup(this);
        this.loadDiscountCodePopup = new LoadDiscountCodePopup(this);
        this.customerLoginPopup = new CustomerLoginPopup(this);
        this.phoneConfirmationPopup = new PhoneConfirmationPopup(this);
        this.popups.add(this.choosePaymentPopup);
        this.popups.add(this.confirmationPopup);
        this.popups.add(this.enterDiscountCodePopup);
        this.popups.add(this.loadDiscountCodePopup);
        this.popups.add(this.customerLoginPopup);
        this.popups.add(this.phoneConfirmationPopup);
    }

    private void setupPanes() {
        this.listOfProductsScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.listOfProductsScrollPane.setFitToWidth(true);
        this.listOfProductsScrollPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.listOfProductsAnchorPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.listOfProductsVBox.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.outerPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.isPopupOpen.bind((ObservableValue)this.choosePaymentPopup.showingProperty().or((ObservableBooleanValue)this.confirmationPopup.showingProperty()).or((ObservableBooleanValue)this.enterDiscountCodePopup.showingProperty()).or((ObservableBooleanValue)this.loadDiscountCodePopup.showingProperty()).or((ObservableBooleanValue)this.customerLoginPopup.showingProperty()).or((ObservableBooleanValue)this.phoneConfirmationPopup.showingProperty()));
        this.mainAnchorPane.disableProperty().bind((ObservableValue)this.isPopupOpen);
        this.footerButtonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        double emptySpace = (double)this.activeConfig.getDisplayConfig().getResolution().getWidth() - (this.backButton.getPrefWidth() + this.discountButton.getPrefWidth() + this.payButton.getPrefWidth());
        double gapSize = emptySpace / 4.0;
        this.beforeSpacer.setMaxWidth(0.0);
        this.footerButtonsFlowPane.setHgap(gapSize);
        this.mainAnchorPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.customerLoggedIn.bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.activeConfig.getCurrentOrder().getCustomerPhoneNumber().equals(""), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().customerPhoneNumberProperty()}));
        this.customerPhoneNumber.textProperty().bind((ObservableValue)this.activeConfig.getCurrentOrder().customerPhoneNumberProperty());
        this.customerPhoneNumber.textProperty().addListener((observable, oldValue, newValue) -> FontUtils.setIdealFont((Label)this.customerPhoneNumber, (Font)this.titleFont));
        this.customerLogOutButton = LayoutUtils.createCircleButton((double)30.0, (String)"/resources/images/red_cross.png");
        this.customerLogOutButton.setOnMouseClicked(mouseEvent -> this.activeConfig.getCurrentOrder().setCustomerPhoneNumber(""));
        this.customerLogOutButton.setOnTouchPressed(touchEvent -> this.activeConfig.getCurrentOrder().setCustomerPhoneNumber(""));
        if (this.customerLoggedIn.get()) {
            this.customerLoginFlowPane.getChildren().remove((Object)this.customerLoginButton);
            if (!this.customerLoginFlowPane.getChildren().contains((Object)this.customerPhoneNumber)) {
                this.customerLoginFlowPane.getChildren().add((Object)this.customerPhoneNumber);
            }
            if (!this.customerLoginFlowPane.getChildren().contains((Object)this.customerLogOutButton)) {
                this.customerLoginFlowPane.getChildren().add((Object)this.customerLogOutButton);
            }
        } else {
            this.customerLoginFlowPane.getChildren().remove((Object)this.customerPhoneNumber);
            this.customerLoginFlowPane.getChildren().remove((Object)this.customerLogOutButton);
            if (!this.customerLoginFlowPane.getChildren().contains((Object)this.customerLoginButton)) {
                this.customerLoginFlowPane.getChildren().add((Object)this.customerLoginButton);
            }
        }
        this.customerLoggedIn.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.customerLoginFlowPane.getChildren().remove((Object)this.customerLoginButton);
                if (!this.customerLoginFlowPane.getChildren().contains((Object)this.customerPhoneNumber)) {
                    this.customerLoginFlowPane.getChildren().add((Object)this.customerPhoneNumber);
                }
                if (!this.customerLoginFlowPane.getChildren().contains((Object)this.customerLogOutButton)) {
                    this.customerLoginFlowPane.getChildren().add((Object)this.customerLogOutButton);
                }
            } else {
                this.customerLoginFlowPane.getChildren().remove((Object)this.customerPhoneNumber);
                this.customerLoginFlowPane.getChildren().remove((Object)this.customerLogOutButton);
                if (!this.customerLoginFlowPane.getChildren().contains((Object)this.customerLoginButton)) {
                    this.customerLoginFlowPane.getChildren().add((Object)this.customerLoginButton);
                }
            }
        });
    }

    private void setupLabels() {
        this.discountAmountLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "- " + FormatUtils.formatCurrencyForceDecimal((double)this.activeConfig.getCurrentOrder().getDiscount(), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().discountProperty()}));
        this.discountAmountLabel.setStyle("-fx-font-color: red");
        this.discountLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.activeConfig.getCurrentOrder().isDiscountApplied(), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().discountPercentageProperty(), this.activeConfig.getCurrentOrder().discountProperty()}));
        this.discountAmountLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.activeConfig.getCurrentOrder().isDiscountApplied(), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().discountPercentageProperty(), this.activeConfig.getCurrentOrder().discountProperty()}));
        this.amountNumberLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> FormatUtils.formatCurrencyForceDecimal((double)this.activeConfig.getCurrentOrder().getTotalPrice(), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().totalPriceProperty()}));
        FontUtils.setIdealFont((Label)this.titleLabel, (Font)this.titleFont);
        FontUtils.setIdealFont((Label)this.discountLabel, (Font)this.subtitleFont);
        FontUtils.setIdealFont((Label)this.amountLabel, (Font)this.subtitleFont);
        FontUtils.setIdealFont((Label)this.customerLoginLabel, (Font)this.titleFont);
        FontUtils.setIdealFont((Label)this.customerPhoneNumber, (Font)this.titleFont);
        this.discountAmountLabel.setFont(this.subtitleFont);
        this.amountNumberLabel.setFont(this.subtitleFont);
        this.emptyCartLabel.setMaxWidth((double)this.activeConfig.getDisplayConfig().getResolution().getWidth());
        this.emptyCartLabel.setPrefWidth((double)this.activeConfig.getDisplayConfig().getResolution().getWidth());
        this.emptyCartLabel.setAlignment(Pos.CENTER);
        this.emptyCartLabel.setTextAlignment(TextAlignment.CENTER);
        FontUtils.setIdealFont((Label)this.emptyCartLabel, (Font)this.titleFont);
    }

    public void setupCart() {
        System.out.println("Setup Cart called");
        this.updateCartContent(this.activeConfig.getCurrentOrder().getOrderItems());
        if (this.cartUpdateListener == null) {
            this.cartUpdateListener = (observable, oldValue, newValue) -> {
                System.out.println("Listener called");
                this.updateCartContent((List)newValue);
            };
            this.activeConfig.getCurrentOrder().orderItemsProperty().addListener(this.cartUpdateListener);
        }
    }

    public void updateCartContent(List<OrderItem> items) {
        System.out.println("Update Cart called");
        this.removeAllChildren((Pane)this.listOfProductsVBox);
        if (items.isEmpty()) {
            this.emptyCartImageView = ResourceHelper.getImageViewFromResourceName((String)"/resources/images/sad_cart_512.png");
            this.emptyCartImageView.setFitHeight(500.0);
            this.emptyCartImageView.setFitWidth(500.0);
            this.listOfProductsVBox.getChildren().addAll((Object[])new Node[]{this.emptyCartLabel, this.emptyCartImageView});
            this.listOfProductsVBox.setAlignment(Pos.CENTER);
        } else {
            this.listOfProductsVBox.setAlignment(Pos.TOP_CENTER);
            this.listOfProductsVBox.setPadding(LayoutUtils.getInsets((double)15.0, (double)0.0, (double)0.0, (double)0.0));
            for (OrderItem orderItem : items) {
                this.listOfProductsVBox.getChildren().add((Object)this.createCartHBox(orderItem));
            }
        }
    }

    public void setupButtons() {
        FontUtils.setIdealFont((Button)this.payButton, (Font)this.titleFont);
        this.payButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.activeConfig.getCurrentOrder().getOrderItems().isEmpty(), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().orderItemsProperty()}));
        FontUtils.setIdealFont((Button)this.discountButton, (Font)this.titleFont);
        this.discountButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.activeConfig.getCurrentOrder().getOrderItems().isEmpty(), (Observable[])new Observable[]{this.activeConfig.getCurrentOrder().orderItemsProperty()}));
        FontUtils.setIdealFont((Button)this.backButton, (Font)this.titleFont);
        FontUtils.setIdealFont((Button)this.customerLoginButton, (Font)this.titleFont);
    }

    private HBox createCartHBox(OrderItem orderItem) {
        Label addItemLabel;
        double hBoxWidth = this.listOfProductsAnchorPane.getPrefWidth() * 0.9;
        double removeWidth = hBoxWidth * 0.025;
        double labelWidth = hBoxWidth * 0.4;
        double imageWidth = hBoxWidth * 0.15;
        double quantityWidth = hBoxWidth * 0.15;
        double priceWidth = hBoxWidth * 0.1;
        Label label = new Label(orderItem.getDisplayName());
        label.setFont(this.cartProductTitleFont);
        label.setWrapText(true);
        VBox labelVBox = new VBox();
        labelVBox.setMinWidth(labelWidth);
        labelVBox.setPrefWidth(labelWidth);
        labelVBox.setAlignment(Pos.CENTER_LEFT);
        labelVBox.getChildren().add((Object)label);
        for (Product addItem : orderItem.getAdditionalProducts()) {
            addItemLabel = new Label("     - " + addItem.getName());
            addItemLabel.setFont(this.cartAddItemsLabelFont);
            addItemLabel.setWrapText(true);
            labelVBox.getChildren().add((Object)addItemLabel);
        }
        for (ProductFreeVariant freeVariant : orderItem.getFreeVariants()) {
            addItemLabel = new Label("     - " + freeVariant.getName());
            addItemLabel.setFont(this.cartAddItemsLabelFont);
            addItemLabel.setWrapText(true);
            labelVBox.getChildren().add((Object)addItemLabel);
        }
        Label totalItemsPrice = new Label();
        totalItemsPrice.setPrefWidth(priceWidth);
        totalItemsPrice.setMinWidth(priceWidth);
        totalItemsPrice.setAlignment(Pos.CENTER_RIGHT);
        totalItemsPrice.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> FormatUtils.formatCurrency((double)(orderItem.getFinalPrice() * (double)orderItem.getQuantity()), (String)"K\u010d"), (Observable[])new Observable[]{orderItem.finalPriceProperty(), orderItem.quantityProperty()}));
        totalItemsPrice.setFont(this.priceLabelFont);
        InputStream is = ResourceHelper.getImageAsStream((String)orderItem.getMainProduct().getImageFilePath());
        Image image = new Image(is);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        Button removeButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/red_cross.png");
        removeButton.setOnMouseClicked(mouseEvent -> this.removeButtonAction(orderItem));
        removeButton.setOnTouchPressed(mouseEvent -> this.removeButtonAction(orderItem));
        Button decreaseButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/minus.png");
        decreaseButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> orderItem.getQuantity() < 2, (Observable[])new Observable[]{orderItem.quantityProperty()}));
        decreaseButton.setOnMouseClicked(mouseEvent -> orderItem.decreaseQuantity());
        decreaseButton.setOnTouchPressed(touchEvent -> orderItem.decreaseQuantity());
        Button increaseButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/plus.png");
        increaseButton.setOnMouseClicked(mouseEvent -> orderItem.increaseQuantity());
        increaseButton.setOnTouchPressed(touchEvent -> orderItem.increaseQuantity());
        Label countLabel = new Label();
        countLabel.setPadding(LayoutUtils.getInsets((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        countLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> FormatUtils.getQuantityLabel((int)orderItem.getQuantity()), (Observable[])new Observable[]{orderItem.quantityProperty()}));
        countLabel.setFont(this.cartQuantityLabelFont);
        HBox quantityHBox = new HBox();
        quantityHBox.setMinWidth(quantityWidth);
        quantityHBox.setPrefWidth(quantityWidth);
        quantityHBox.setMaxWidth(quantityWidth);
        quantityHBox.setAlignment(Pos.CENTER);
        quantityHBox.getChildren().addAll((Object[])new Node[]{decreaseButton, countLabel, increaseButton});
        HBox orderItemHBox = new HBox(20.0);
        orderItemHBox.setPrefWidth(hBoxWidth);
        orderItemHBox.setMaxWidth(hBoxWidth);
        orderItemHBox.setMinWidth(hBoxWidth);
        orderItemHBox.setMinHeight(125.0);
        orderItemHBox.setAlignment(Pos.CENTER);
        orderItemHBox.getStyleClass().add((Object)"orderItemHBox");
        orderItemHBox.setPadding(LayoutUtils.getInsets((double)0.0, (double)15.0, (double)0.0, (double)15.0));
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)countLabel, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)imageView, (Priority)Priority.NEVER);
        orderItemHBox.getChildren().addAll((Object[])new Node[]{removeButton, imageView, labelVBox, quantityHBox, totalItemsPrice});
        return orderItemHBox;
    }

    public List<DiscountCode> getDiscountCodesForCustomer() {
        String customerPhoneNumber = this.activeConfig.getCurrentOrder().getCustomerPhoneNumber();
        List codesResponse = this.partnerServerRestClient.getUsableValidDiscountCodesForCustomer(customerPhoneNumber);
        return codesResponse.stream().map(DiscountCode::new).toList();
    }

    public void useDiscount(DiscountCodeVerifyResponse response, String code) {
        if (response.isPercentage()) {
            this.activeConfig.getCurrentOrder().setDiscount(0.0);
            this.activeConfig.getCurrentOrder().setDiscountPercentage(response.getAmount());
        } else if (response.isMonetary()) {
            this.activeConfig.getCurrentOrder().setDiscountPercentage(0.0);
            this.activeConfig.getCurrentOrder().setDiscount(response.getAmount());
        }
        this.activeConfig.getCurrentOrder().setDiscountCode(code);
    }

    @FXML
    private void backButtonAction() {
        if (this.cartUpdateListener != null) {
            this.activeConfig.getCurrentOrder().orderItemsProperty().removeListener(this.cartUpdateListener);
            this.cartUpdateListener = null;
        }
        this.switchToMainScene();
    }

    @FXML
    private void discountButtonAction() {
        this.loadDiscountCodePopup.loadPopup();
    }

    @FXML
    private void payButtonAction() {
        if (this.customerLoggedIn.get()) {
            this.goToPayment();
        } else {
            this.customerLoginPopup.loadPopup(true);
        }
    }

    public void goToPayment() {
        if (this.activeConfig.getCurrentOrder().getTotalPrice() > 0.0) {
            this.choosePaymentPopup.loadPopup();
        } else {
            this.payByCashButtonAction(true);
        }
    }

    @FXML
    private void loginCustomerAction() {
        this.customerLoginPopup.loadPopup();
    }

    public void payByCardButtonAction() {
        String newOrderId;
        this.activeConfig.getCurrentOrder().setPaymentMethod(PAYMENT_METHOD.CARD);
        if (this.activeConfig.getCurrentOrder().getId() == null || this.activeConfig.getCurrentOrder().getId().trim().isEmpty()) {
            newOrderId = this.orderService.saveNewPersonalOrder(this.activeConfig.getCurrentOrder());
        } else {
            this.orderService.update(this.activeConfig.getCurrentOrder());
            newOrderId = this.activeConfig.getCurrentOrder().getId();
        }
        this.activeConfig.setCurrentOrder(this.orderService.findByIdNamed(newOrderId));
        this.initCardPayment(Double.valueOf(this.activeConfig.getCurrentOrder().getTotalPrice()));
    }

    public void payByCashButtonAction() {
        this.payByCashButtonAction(false);
    }

    public void payByCashButtonAction(boolean alreadyPaid) {
        String newOrderId;
        this.activeConfig.getCurrentOrder().setPaymentMethod(PAYMENT_METHOD.CASH);
        System.out.println("Saving order ID: " + this.activeConfig.getCurrentOrder().getId());
        if (this.activeConfig.getCurrentOrder().getId() == null || this.activeConfig.getCurrentOrder().getId().trim().isEmpty()) {
            newOrderId = this.orderService.saveNewPersonalOrder(this.activeConfig.getCurrentOrder());
        } else {
            this.activeConfig.getCurrentOrder().setOrderStatus(ORDER_STATUS.WAITING_FOR_PAYMENT);
            this.orderService.update(this.activeConfig.getCurrentOrder());
            newOrderId = this.activeConfig.getCurrentOrder().getId();
        }
        this.activeConfig.setCurrentOrder(this.orderService.findByIdNamed(newOrderId));
        if (alreadyPaid) {
            this.confirmOrderPaid();
        } else if (this.activeConfig.getPrinterConfig().isEnabled()) {
            this.printOrderNumber(this.activeConfig.getCurrentOrder(), true, true);
        }
        this.choosePaymentPopup.hide();
        this.confirmationPopup.loadPopup(this.activeConfig.getCurrentOrder(), PAYMENT_METHOD.CASH);
        if (this.activeConfig.getCurrentOrder().isDiscountApplied() && this.activeConfig.getCurrentOrder().getDiscountCode() != null) {
            this.notifyAboutDiscountCodeUsage(this.activeConfig.getCurrentOrder().getDiscountCode(), this.activeConfig.getCurrentOrder().getId());
        }
        this.activeConfig.setCurrentOrder(new Order());
    }

    private void initCardPayment(Double price) {
        MDBController mdbController;
        block14: {
            this.choosePaymentPopup.disableCancelButton();
            mdbController = this.activeConfig.getMdbController();
            try {
                boolean cashlessInited = mdbController.checkCashlessInited();
                System.out.println("A: " + cashlessInited);
                if (cashlessInited) {
                    boolean cashlessActive = mdbController.checkCashlessActive();
                    System.out.println("B: " + cashlessActive);
                    if (!cashlessActive) {
                        cashlessActive = mdbController.enableCashless(true);
                        System.out.println("C: " + cashlessActive);
                        if (!cashlessActive) {
                            System.out.println("Cashless device is inited, but cannot be enabled.");
                            throw new IllegalStateException("Cashless device is inited, but cannot be enabled.");
                        }
                        status = mdbController.getCashlessStatus();
                        System.out.println("I: " + status);
                    } else {
                        status = mdbController.getCashlessStatus();
                        System.out.println("H: " + status);
                    }
                    break block14;
                }
                System.out.println("Cashless device not Inited. Check if it's connected and powered on.");
                throw new IllegalStateException("Cashless device not Inited. Check if it's connected and powered on.");
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                try {
                    mdbController.close();
                }
                catch (IOException ex) {
                    ExceptionHandler.logException((Exception)ex);
                }
                MDBConfig mdbConfig = this.activeConfig.getMdbConfig();
                this.activeConfig.setMdbController(new MDBController(mdbConfig.getPort(), mdbConfig.getBaudRate(), mdbConfig.getBitLength(), mdbConfig.getStopBits()));
                mdbController = this.activeConfig.getMdbController();
            }
        }
        boolean success = mdbController.startCashlessTransaction(price.intValue(), 1);
        if (success) {
            boolean transactionApproved = false;
            boolean authorizationFailed = false;
            long startTime = System.currentTimeMillis();
            while (!transactionApproved && System.currentTimeMillis() - startTime < 100000L && !authorizationFailed) {
                ArrayList responses = new ArrayList(mdbController.getResponseStack());
                for (String res : responses) {
                    if (res.matches("CSLS1VNDAPP\\(" + price.intValue() + ".*")) {
                        transactionApproved = true;
                        Platform.runLater(() -> {});
                    }
                    if (!res.matches("CSLS1VNDDEN")) continue;
                    authorizationFailed = true;
                    this.choosePaymentPopup.enableCancelButton();
                    Platform.runLater(() -> {
                        if (!this.activeConfig.isDeclinedCardTransactionAsApproved()) {
                            this.choosePaymentPopup.setStatusLabelText(this.strings.getString("confirmation.label.paymentFailed"));
                            this.choosePaymentPopup.statusLabel.getParent().requestLayout();
                        }
                    });
                }
            }
            if (!transactionApproved) {
                System.out.println("F");
                Platform.runLater(() -> {
                    this.choosePaymentPopup.enableCancelButton();
                    if (this.activeConfig.isDeclinedCardTransactionAsApproved()) {
                        this.confirmOrderPaid();
                    } else {
                        this.activeConfig.getCurrentOrder().setOrderStatus(ORDER_STATUS.CANCELLED);
                        this.orderService.update(this.activeConfig.getCurrentOrder());
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            ExceptionHandler.logException((Exception)e);
                        }
                        this.choosePaymentPopup.hideStatusLabel();
                        this.choosePaymentPopup.showButtons();
                    }
                });
            } else {
                System.out.println("G");
                mdbController.confirmVending(1, false);
                Platform.runLater(() -> this.confirmOrderPaid());
            }
        }
    }

    private void confirmOrderPaid() {
        if (this.activeConfig.getCurrentOrder().isTaxRelevant()) {
            this.createReceipt(this.activeConfig.getPrinterConfig().isEnabled(), true);
        }
        this.activeConfig.getCurrentOrder().setOrderStatus(ORDER_STATUS.CONFIRMED);
        this.orderService.update(this.activeConfig.getCurrentOrder());
        this.choosePaymentPopup.hide();
        this.confirmationPopup.loadPopup(this.activeConfig.getCurrentOrder(), PAYMENT_METHOD.CARD);
        if (this.activeConfig.getCurrentOrder().isDiscountApplied() && this.activeConfig.getCurrentOrder().getDiscountCode() != null) {
            this.notifyAboutDiscountCodeUsage(this.activeConfig.getCurrentOrder().getDiscountCode(), this.activeConfig.getCurrentOrder().getId());
        }
        this.activeConfig.setCurrentOrder(new Order());
    }

    private void removeButtonAction(OrderItem orderItem) {
        this.activeConfig.getCurrentOrder().removeOrderItem(orderItem);
    }

    private void notifyAboutDiscountCodeUsage(String discountCode, String orderId) {
        this.activeConfig.getPartnerServerRestClient().notifyAboutDiscountCodeUsage(discountCode, orderId);
    }

    public void createReceipt(boolean print, boolean includeOrderNumber) {
        Order order = this.activeConfig.getCurrentOrder();
        Receipt receipt = new Receipt(order, null);
        receipt.setLocation(this.activeConfig.getKioskName() + " (" + this.activeConfig.getKioskInfo().getKioskId() + ")");
        List header = this.activeConfig.getKioskInfo().getReceiptInfo().getHeader();
        String footer = this.activeConfig.getKioskInfo().getReceiptInfo().getFooter();
        String logoImageName = this.activeConfig.getPrinterConfig().getLogoImageName();
        int characters = this.activeConfig.getPrinterConfig().getCharacters();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        byte[] orderNumberData = new byte[]{};
        receipt.setHeader(header);
        receipt.setFooter(footer);
        this.receiptService.save(receipt);
        if (print) {
            if (includeOrderNumber) {
                orderNumberData = ReceiptPrinter.getOrderNumberBytes((Order)order, new ArrayList(), (KioskInfo)this.activeConfig.getKioskInfo(), (String)logoImageName, (boolean)true, (int)characters, (String)encoding);
            }
            this.printReceipt(receipt, orderNumberData);
        }
    }

    public void printReceipt(Receipt receipt, byte[] orderNumberData) {
        String printerName = this.activeConfig.getPrinterConfig().getPrinterName();
        String logoImageName = this.activeConfig.getPrinterConfig().getLogoImageName();
        int characters = this.activeConfig.getPrinterConfig().getCharacters();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        ReceiptPrinter.printReceipt((Receipt)receipt, (String)printerName, (KioskInfo)this.activeConfig.getKioskInfo(), (String)logoImageName, (int)characters, (String)encoding, (byte[])orderNumberData);
    }

    public void printOrderNumber(Order order, boolean printHeader, boolean cutAfterPrint) {
        String printerName = this.activeConfig.getPrinterConfig().getPrinterName();
        ArrayList header = printHeader ? this.activeConfig.getKioskInfo().getReceiptInfo().getHeader() : new ArrayList();
        String logoImageName = this.activeConfig.getPrinterConfig().getLogoImageName();
        int characters = this.activeConfig.getPrinterConfig().getCharacters();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        byte[] orderNumberData = ReceiptPrinter.getOrderNumberBytes((Order)order, header, (KioskInfo)this.activeConfig.getKioskInfo(), (String)logoImageName, (boolean)cutAfterPrint, (int)characters, (String)encoding);
        ReceiptPrinter.printOrderNumber((byte[])orderNumberData, (String)printerName);
    }

    public EnterDiscountCodePopup getEnterDiscountCodePopup() {
        return this.enterDiscountCodePopup;
    }

    public LoadDiscountCodePopup getLoadDiscountCodePopup() {
        return this.loadDiscountCodePopup;
    }

    public CustomerLoginPopup getCustomerLoginPopup() {
        return this.customerLoginPopup;
    }

    public PhoneConfirmationPopup getPhoneConfirmationPopup() {
        return this.phoneConfirmationPopup;
    }

    public InternetConnectivityService getInternetConnectivityService() {
        return this.internetConnectivityService;
    }
}

