/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import cz.polreich.spagetka.CustomerStarter;
import cz.polreich.spagetka.StageReadyEvent;
import cz.polreich.spagetka.controllers.loading.CustomerLoadingController;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.DiscountCouponService;
import cz.polreich.spagetka.service.OrderItemService;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.RecipeStepService;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.service.UserService;
import java.io.IOException;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomerApp
extends Application {
    private ConfigurableApplicationContext springContext;
    private CustomerLoadingController customerLoadingController;
    private Config config;
    private CustomerConfig activeConfig;
    private Font font;
    @Autowired
    public CategoryService categoryService;
    @Autowired
    public DiscountCouponService discountCouponService;
    @Autowired
    public OrderItemService orderItemService;
    @Autowired
    public OrderService orderService;
    @Autowired
    public ProductService productService;
    @Autowired
    public RecipeStepService recipeStepService;
    @Autowired
    public StockItemService stockItemService;
    @Autowired
    public UserService userService;

    public void start(Stage stage) throws IOException {
        this.springContext.publishEvent((ApplicationEvent)new StageReadyEvent(stage));
        this.config = (Config)this.springContext.getBean(Config.class);
        this.config.setCustomerSelected();
        this.activeConfig = this.config.getCustomer();
        this.loadScene(stage);
    }

    public void stop() {
        this.springContext.stop();
        Platform.exit();
    }

    public void init() {
        this.springContext = new SpringApplicationBuilder(new Class[]{CustomerStarter.class}).run(new String[0]);
    }

    public void loadScene(Stage stage) throws IOException {
        Rectangle2D screenBounds;
        int sceneWidth = 600;
        int sceneHeight = 600;
        ResourceBundle strings = ResourceBundle.getBundle("resources.strings.cashier", this.activeConfig.getSelectedLocale());
        FXMLLoader loader = new FXMLLoader(CustomerApp.class.getResource("loadingCustomer.fxml"), strings);
        loader.setControllerFactory(arg_0 -> ((ConfigurableApplicationContext)this.springContext).getBean(arg_0));
        Parent root = (Parent)loader.load();
        stage.initStyle(StageStyle.TRANSPARENT);
        System.setProperty("prism.lcdtext", "false");
        this.customerLoadingController = (CustomerLoadingController)loader.getController();
        this.customerLoadingController.setupStage(stage, strings);
        Scene scene = new Scene(root, (double)sceneWidth, (double)sceneHeight);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.setFullScreen(false);
        stage.setTitle("Spagetka BranchClient loader v0.0.1");
        try {
            screenBounds = ((Screen)Screen.getScreens().get(this.activeConfig.getDisplayConfig().getScreenId())).getVisualBounds();
        }
        catch (Exception e) {
            screenBounds = ((Screen)Screen.getScreens().get(0)).getVisualBounds();
        }
        stage.setX((screenBounds.getWidth() - (double)sceneWidth) / 2.0 + screenBounds.getMinX());
        stage.setY((screenBounds.getHeight() - (double)sceneHeight) / 2.0 + screenBounds.getMinY());
        stage.show();
    }

    public static void main(String[] args) {
        CustomerApp.launch(CustomerApp.class, (String[])args);
    }
}

