#!/bin/bash

set -e

case "$SUDO_USER" in
  kioskuser)
    echo "🔄 Switching to adminuser on next boot..."
    echo -e "[Autologin]\nUser=adminuser\nSession=plasma" > /etc/sddm.conf.d/autologin.conf
    ;;
  adminuser)
    echo "🔄 Switching to kioskuser on next boot..."
    echo -e "[Autologin]\nUser=kioskuser\nSession=plasma" > /etc/sddm.conf.d/autologin.conf
    ;;
  *)
    echo "❌ Unsupported user: $SUDO_USER"
    exit 1
    ;;
esac

echo "♻️ Rebooting now..."
sleep 2
sudo reboot