#!/bin/bash

#Variables
    username="bestseries"
    newAppVersion="0.6.5"
    rootInstallPath="/home/$username/Desktop/Client"
    rootParent=$(dirname "rootInstallPath")
    configPath=$rootInstallPath/resources/config.json

# Install dependencies and updating system
echo "1) ######### Update systemu a Kontrola a instalace dependenci #########"
pkexec apt update -y
pkexec apt upgrade -y
jqStatus="$(dpkg-query --show --showformat='${db:Status-Status}\n' jq 2>/dev/null)"
meldStatus="$(dpkg-query --show --showformat='${db:Status-Status}\n' meld 2>/dev/null)"
if [ ! "$jqStatus" = "installed" ]
then
    pkexec apt install jq -y
fi
if [ ! "$meldStatus" = "installed" ]
then
    pkexec apt install meld -y
fi

# Move old backup to backup backup
echo "2) ######### Zalohovani #########"
if [ -d "$rootParent/Backup_Client" ]
then
    mv "$rootParent/Backup_Client" "$rootParent/Backup_Client_old"
else
    echo "Stary backup nenalezen."
fi

# Create new backup
cp -rp "$rootParent/Client" "$rootParent/Backup_Client"
echo "Vytvoren novy backup."

# Move logs to archive
echo "3) ######### Archivace logu #########"
if [ ! -d "$rootInstallPath/logs_archive" ]
then
    mkdir $rootInstallPath/logs_archive
fi
find $rootInstallPath -maxdepth 1 -name "log_*.txt" -exec mv -t $rootInstallPath/logs_archive/ {} +

# Remove old files
echo "4) ######### Odstraneni stare verze #########"
rm -rf $rootInstallPath/conf
rm -rf $rootInstallPath/legal
rm -rf $rootInstallPath/lib
rm -f $rootInstallPath/bin/java
rm -f $rootInstallPath/bin/jrunscript
rm -f $rootInstallPath/bin/keytool

# Extract new files
echo "5) ######### Instalace nove verze #########"
if [ -d "$rootParent/ClientTemp" ]
then
    rm -rf "$rootParent/ClientTemp"
fi
mkdir "$rootParent/ClientTemp"
unzip "$rootParent/damePradloClient_""$newAppVersion""_update.zip" -d "$rootParent/ClientTemp"
rm -f "$rootParent/ClientTemp/bin/damePradloClient" || true
rm -f "$rootParent/ClientTemp/resources/config.json" || true
cp -R "$rootParent/ClientTemp"/* $rootInstallPath

# Handle config file
echo "6) ######### Kontrola konfiguracnich souboru #########"
machineId=$(jq -r .machineId $configPath)
countryCode=${machineId:(-2)}
defaultConfigFile="$rootParent/ClientTemp/resources/defaultConfig$countryCode.json"
configFromUpdate="$rootInstallPath/resources/configFromUpdate.json"
cp $defaultConfigFile $configFromUpdate
sed -i "s/%%MACHINE_ID%%/$machineId/g" $configFromUpdate
find "$rootInstallPath/resources" -type f -name "defaultConfig*.json" -exec rm -f {} \;

# Remove temp files
echo "7) ######### Odstraneni docasnych souboru #########"
rm -Rf "$rootParent/ClientTemp"

# Set executables
echo "8) ######### Nastaveni opravneni #########"
chmod +x "$rootInstallPath/bin/"*
chmod +x "$rootInstallPath/lib/jexec"
chmod +x "$rootInstallPath/lib/jrt-fs.jar"
chmod +x "$rootInstallPath/lib/jspawnhelper"

# Delete old backup and install package
echo "9) ######### Odstraneni stare zalohy #########"
rm -f "$rootParent/damePradloClient_""$newAppVersion""_update.zip"
rm -rf "$rootParent/Backup_Client_old"

# Compare config files
echo "10) ######### Porovnani konfiguracnich souboru #########"
areDifferent=$(diff <(jq . $configPath) <(jq . $configFromUpdate))
if [ "$areDifferent" -eq 0 ]
then
    echo "Konfiguracni soubory jsou totozne. Neni potreba zadna zmena."
else
    meld $configPath $configFromUpdate
fi

echo "***************** HOTOVO *****************"
read -p "Stisknete ENTER pro restart."
reboot