#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-finalConfig.log"
exec > >(tee -a "$LOGFILE") 2>&1

current_step="initial setup"
trap 'echo -e "\n❌ Script failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️  $current_step"
}

preserve_kde_desktop_icon_only() {
    local config_file="$CONFIG_DIR/plasma-org.kde.plasma.desktop-appletsrc"
    local tmp_file="$CONFIG_DIR/plasma-org.kde.plasma.desktop-appletsrc.new"

    echo "🔍 Extracting containment with plugin=org.kde.plasma.folder and ScreenMapping..."

        awk '
        BEGIN {
            inside_containment = 0
            save_containment = 0
            inside_screen = 0
            buffer = ""
        }

        /^\[Containments\]\[[0-9]+\]/ {
            if (save_containment) print buffer
            buffer = $0 ORS
            inside_containment = 1
            save_containment = 0
            next
        }

        /^\[ScreenMapping\]/ {
            if (save_containment) print buffer
            inside_containment = 0
            save_containment = 0
            inside_screen = 1
            print
            next
        }

        /^\[.*\]/ {
            if (save_containment) print buffer
            buffer = ""
            inside_containment = 0
            save_containment = 0
            inside_screen = 0
            next
        }

        inside_containment {
            buffer = buffer $0 ORS
            if ($0 ~ /plugin=org.kde.plasma.folder/) {
                save_containment = 1
            }
            next
        }

        inside_screen {
            print
            next
        }

        ' "$config_file" > "$tmp_file"

        echo "💾 Replacing config with minimal layout..."
        mv "$tmp_file" "$config_file"
        chown kioskuser:kioskuser "$config_file"
}

# Variables
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
parent=$(dirname "$dir")
kioskuser=$1
adminuser=$2
USER_HOME="/home/$kioskuser"
CONFIG_DIR="$USER_HOME/.config"

section "Clear KDE panels and lock widgets"
preserve_kde_desktop_icon_only

cat <<EOF > "$CONFIG_DIR/plasmarc"
[General]
Immutable=true
EOF

cat <<EOF > /etc/xdg/kdeglobals
[KDE]
ShowRunCommand=false
lockOnResume=false
[\$i]
EOF

cat <<EOF > /home/$kioskuser/.config/powermanagementprofilesrc
[AC][DPMSControl]
idleTime=0

[AC][SuspendSession]
idleTime=0
suspendType=0

[Battery][SuspendSession]
suspendType=0
EOF

cat <<EOF > /home/$kioskuser/.config/kscreenlockerrc
[Daemon]
Autolock=false
LockOnResume=false
EOF

cat <<EOF > /home/$kioskuser/.config/kwinrc
[ScreenSaver]
Enabled=false
EOF

section "Nastaveni automatickeho prihlaseni uzivatele kioskuser"
mkdir -p /etc/sddm.conf.d
cat <<EOF > /etc/sddm.conf.d/autologin.conf
[Autologin]
User=kioskuser
Session=plasma
EOF

section "Install systemd timers for calibration"
mkdir -p /home/$kioskuser/.config/systemd/user
cp $dir/calibrateService/calibrate-touch.service /home/$kioskuser/.config/systemd/user/
cp $dir/calibrateService/calibrate-touch.timer /home/$kioskuser/.config/systemd/user/
chown $kioskuser:$kioskuser /home/$kioskuser/.config/systemd/user/calibrate-touch.*
systemctl --user daemon-reload
systemctl --user enable --now calibrate-touch.timer
systemctl --user enable --now calibrate-touch-2.timer

section "Nastaveni rotace obrazovky"
mkdir -p /home/$kioskuser/.config/autostart-scripts
cp "$dir/autostart/rotateScreen.sh" /home/$kioskuser/.config/autostart-scripts/rotateScreen.sh
chmod +x /home/$kioskuser/.config/autostart-scripts/rotateScreen.sh
chown -R $kioskuser:$kioskuser /home/$kioskuser/.config/autostart-scripts

mkdir -p /home/$adminuser/.config/autostart-scripts
cp "$dir/autostart/rotateScreen.sh" /home/$adminuser/.config/autostart-scripts/rotateScreen.sh
chmod +x /home/$adminuser/.config/autostart-scripts/rotateScreen.sh
chown -R $adminuser:$adminuser /home/$adminuser/.config/autostart-scripts

section "Nastaveni pozadi obrazovky"
mkdir -p /home/$kioskuser/.config/autostart-scripts
cp "$dir/autostart/setKioskWallpaper.sh" /home/$kioskuser/.config/autostart-scripts/setKioskWallpaper.sh
chmod +x /home/$kioskuser/.config/autostart-scripts/setKioskWallpaper.sh
chown -R $kioskuser:$kioskuser /home/$kioskuser/.config/autostart-scripts

section "✅ Hotovo"
