#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-configApp.log"
exec > >(tee -a "$LOGFILE") 2>&1

current_step="initial setup"
trap 'echo -e "\n❌ Script failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️  $current_step"
}

# Variables
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
parent=$(dirname "$dir")
kioskuser=$1
adminuser=$2

washerManuRadioText="Vyber výrobce praček:\nZvol pomocí šipek, označ pomocí MEZERNÍKU a potvrď pomocí ENTERu."
drierManuRadioText="Vyber výrobce sušičky:\nZvol pomocí šipek, označ pomocí MEZERNÍKU a potvrď pomocí ENTERu."
countryRadioText="Vyber výchozí jazyk a zemi instalace kiosku:\nZvol pomocí šipek, označ pomocí MEZERNÍKU a potvrď pomocí ENTERu."

section "Nastaveni spustitelneho souboru aplikace"
echo "Copying application launcher..."
cp "$dir/bin/damePradloClient" "/home/$kioskuser/Desktop/Client/bin/damePradloClient"
chmod a+x "/home/$kioskuser/Desktop/Client/bin/damePradloClient"

section "Vyber zeme"
country=$(dialog --clear --no-cancel --no-tags --radiolist "$countryRadioText" 50 150 30 \
  "CZ" "Čeština - Česko (cs_CZ)" ON \
  "PL" "Polština - Polsko (pl_PL)" OFF \
  "SK" "Slovenština - Slovensko (sk_SK)" OFF \
  "UK" "Angličtina - Spojené království (en_GB)" OFF \
  "IE" "Angličtina - Irsko (en_IE)" OFF \
  --output-fd 1)

section "Vyber typ pradlomatu"
machineType=$(dialog --clear --no-cancel --no-tags --radiolist "Vyber typ prádlomatu:" 50 150 30 \
  "large" "Velký - 2x pračka + 1x sušička" ON \
  "small" "Malý - 1x pračka + 1x sušička" OFF \
  --output-fd 1)

section "Vyber vyrobce pracek"
washerManu=$(dialog --clear --no-cancel --no-tags --radiolist "$washerManuRadioText" 50 150 30 \
  "alliance" "Alliance (Primus Protocol)" ON \
  "neurawash" "NeuraWash (NeuraWash Protocol)" OFF \
  "electrolux" "Electrolux (Compass Pro Protocol)" OFF \
  --output-fd 1)

section "Vyber vyrobce susicky"
drierManu=$(dialog --clear --no-cancel --no-tags --radiolist "$drierManuRadioText" 50 150 30 \
  "alliance" "Alliance (Primus Protocol)" ON \
  "neurawash" "NeuraWash (NeuraWash Protocol)" OFF \
  "electrolux" "Electrolux (Compass Pro Protocol)" OFF \
  --output-fd 1)

section "Platba v hotovosti"
cashEnabled=$(dialog --no-cancel --clear --yesno "Chcete povolit platbu v hotovosti?" 10 150 --output-fd 1)

section "Platba kartou"
cardEnabled=$(dialog --no-cancel --clear --yesno "Chcete povolit platbu kartou?" 10 150 --output-fd 1)

section "Zadej ID kiosku"
machineId=$(dialog --no-cancel --clear --inputbox "Zadej id kiosku (napr. 00001XX)" 10 150 --output-fd 1)

section "Generovani konfiguracniho souboru"
defaulConfigFileName="/home/$kioskuser/Desktop/Client/resources/defaultConfig$country.json"
finalConfigFileName="/home/$kioskuser/Desktop/Client/resources/config.json"
resourcesDir="/home/$kioskuser/Desktop/Client/resources/"

cp "$defaulConfigFileName" "$finalConfigFileName"
sed -i "s/%%MACHINE_ID%%/$machineId/g" "$finalConfigFileName"

section "Cisteni defaultnich konfiguraci"
find "$resourcesDir" -type f -name "defaultConfig*.json" -exec rm -f {} \;

section "✅ Hotovo"
read -rp $'Hotovo. Restart neni potreba.\n🔸 Stiskni ENTER pro návrat do hlavní nabídky...'
