#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-installApp.log"
exec > >(tee -a "$LOGFILE") 2>&1

current_step="initial setup"
trap 'echo -e "\n❌ Script failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️  $current_step"
}

# Variables
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
parent=$(dirname "$dir")
kioskuser=$1
adminuser=$2
appVersion="0.7.0"
clientDir="/home/$kioskuser/Desktop/Client"

msgText="V nasledujicim dialogu vyberte ZIP soubor s aplikaci napsanim cesty do spodniho radku\n\nPouzijte lomitko \"/\" pro oddeleni slozek a mezernik pro automaticke doplneni nazvu\n\nAbyste mohli psat, musi byt sedy kurzor v radku pro zadani cesty. Pouzijte sipky pro nastaveni kurzoru na spravne misto pro psani.\n\nCesta musi napsana cela, pote potvrdte ENTERem.\n\nPouzijte Ctrl+C pro zruseni instalace."

function punzip {
   unzip "$1" -d "$2" | pv -l -s $(unzip -Z -1 "$1" | wc -l) > /dev/null;
}

section "Vyber ZIP souboru"
appFileName=$(dialog --begin 0 0 --keep-window --msgbox "$msgText" 40 150 --and-widget --begin 13 0 --clear --fselect "$parent/damePradloClient_$appVersion.zip" 20 150 --output-fd 1)

section "Vytvoreni slozky aplikace"
if [ ! -d "$clientDir" ]; then
    echo "Creating client directory at $clientDir"
    mkdir "$clientDir"
else
    echo "Client directory already exists at $clientDir"
fi

section "Rozbaleni aplikace"
echo "Unzipping $appFileName into $clientDir..."
unzip "$appFileName" -d "$clientDir"

section "Nastavení oprávnění"
chown -R $kioskuser:$kioskuser $clientDir
chmod +x "$clientDir/bin/"*
chmod +x "$clientDir/lib/jexec"
chmod +x "$clientDir/lib/jrt-fs.jar"
chmod +x "$clientDir/lib/jspawnhelper"

section "✅ Hotovo"
read -rp $'Hotovo. Restart neni potreba.\n🔸 Stiskni ENTER pro návrat do hlavní nabídky...'