#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-usb.log"
exec > >(tee -a "$LOGFILE") 2>&1

current_step="initial setup"
trap 'echo -e "\n❌ Script failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️  $current_step"
}

function showMsgBox() {
    dialog --clear --msgbox "$1" 10 150
}

function showInputBox() {
    dialog --no-cancel --clear --inputbox "$1" 10 150 --output-fd 1
}

# Variables
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
kioskuser=$1
adminuser=$2
radioText="Vyber vyrobce pracek:\nZvol pomoci sipek, oznac pomoci MEZERNIKU a potvrd pomoci ENTERu."

section "Vyber vyrobce"
manu=$(dialog --clear --no-cancel --no-tags --radiolist "$radioText" 50 150 30 \
  "alliance" "Alliance (Primus Protocol)" ON \
  "electrolux" "Electrolux (Compass Pro Protocol)" OFF \
  --output-fd 1)

section "Konfigurace MDB Controlleru"
showMsgBox "Pripojte MDB Controller a stisknete Enter"
mdb_idProduct=$(showInputBox "Zadejte 'idProduct' parametr:")

section "Konfigurace CCTalk Controlleru"
showMsgBox "Pripojte CCTalk Controller a stisknete Enter"
ccTalk_serialNumber=$(showInputBox "Zadejte 'SerialNumber' parametr:")

if [[ $manu == "alliance" ]]; then
    section "Konfigurace RS485 prevodniku"
    showMsgBox "Pripojte RS485 prevodnik a stisknete Enter"
    rs485_serialNumber=$(showInputBox "Zadejte 'SerialNumber' parametr:")
else
    if [[ $manu == "electrolux" ]]; then
        echo "Electrolux not implemented yet!"
        #TODO: Add Electrolux USB config
    fi
fi

section "Zapis udev pravidel"
echo "SUBSYSTEM==\"tty\", ATTRS{serial}==\"$ccTalk_serialNumber\", SYMLINK+=\"ttyCCTalk\"" | tee /etc/udev/rules.d/99-usb-serial.rules
echo "SUBSYSTEM==\"tty\", ATTRS{idProduct}==\"$mdb_idProduct\", SYMLINK+=\"ttyMDB\"" | tee -a /etc/udev/rules.d/99-usb-serial.rules

if [[ $manu == "alliance" ]]; then
    echo "SUBSYSTEM==\"tty\", ATTRS{serial}==\"$rs485_serialNumber\", SYMLINK+=\"ttyPrimus\"" | tee -a /etc/udev/rules.d/99-usb-serial.rules
else
    if [[ $manu == "electrolux" ]]; then
        echo "Electrolux not implemented yet!"
        #TODO: Add Electrolux USB config
    fi
fi

section "✅ Hotovo"
read -rp "Hotovo. Stiskni ENTER pro restart"
sudo -u $adminuser reboot