#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-rele.log"
exec > >(tee -a "$LOGFILE") 2>&1

current_step="initial setup"
trap 'echo -e "\n❌ Script failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️  $current_step"
}

function showMsgBox() {
    dialog --clear --msgbox "$1" 10 150
}

# Variables
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
kioskuser=$1
adminuser=$2

section "Start USB relay configuration"
showMsgBox "Odpoj vsechna rele a stiskni Enter"

section "Nastavuji M-V rele"
showMsgBox "Pripoj 'M-V rele' a stiskni Enter"
usbrelay BITFT_0=M-V
usbrelay HURTM_0=M-V

section "Nastavuji H-M rele"
showMsgBox "Odpoj 'M-V' rele, pripoj 'H-M' rele a stiskni Enter"
usbrelay BITFT_0=H-M
usbrelay HURTM_0=H-M

section "Nastavuji L-P rele"
showMsgBox "Odpoj 'H-M' rele, pripoj 'L-P' rele a stiskni Enter"
usbrelay BITFT_0=L-P
usbrelay HURTM_0=L-P

section "Zapis pravidel udev pro usbrelay"
showMsgBox "Pripoj vsechna rele a stiskni Enter"
echo "SUBSYSTEM==\"usb\", ATTR{idVendor}==\"16c0\",ATTR{idProduct}==\"05df\", MODE=\"0666\"" | tee /etc/udev/rules.d/50-usbrelay.rules
echo "KERNEL==\"hidraw*\",  ATTRS{idVendor}==\"16c0\", ATTRS{idProduct}==\"05df\", MODE=\"0666\", GROUP=\"usbrelay\", TAG+=\"systemd\" ENV{SYSTEMD_WANTS}=\"usbrelayd.service\"" | tee -a /etc/udev/rules.d/50-usbrelay.rules
echo "KERNEL==\"hidraw*\",  ATTRS{idVendor}==\"0519\", ATTRS{idProduct}==\"2018\", MODE=\"0666\", GROUP=\"usbrelay\", SYMLINK+=\"usbrelay%b\"" | tee -a /etc/udev/rules.d/50-usbrelay.rules

section "Zobrazit stav rele"
dialog --clear --msgbox "$(usbrelay)" -1 -1

section "✅ Hotovo"
read -rp $'\n🔸 Stiskni ENTER pro návrat do hlavní nabídky...'