#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-teamviewer.log"
exec > >(tee -a "$LOGFILE") 2>&1

current_step="initial setup"
trap 'echo -e "\n❌ Installation failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️  $current_step"
}

# Variables
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
kioskuser=$1
adminuser=$2

section "Stahuji TeamViewer Host"
echo "Downloading TeamViewer Host to /home/$adminuser/Downloads..."
sudo -u "$adminuser" bash -c "mkdir -p /home/$adminuser/Downloads && cd /home/$adminuser && wget -q -O Downloads/teamviewer-host_amd64.deb https://download.teamviewer.com/download/linux/teamviewer-host_amd64.deb"

section "Instaluji TeamViewer Host"
echo "Installing TeamViewer Host..."
apt install /home/$adminuser/Downloads/teamviewer-host_amd64.deb -y

section "✅ Hotovo"
echo "TeamViewer instalace dokoncena."
read -rp $'Instalace dokoncena. Nyni provedte konfiguraci TeamViewer aplikace podle kroku popsanych v manualu.\n🔸 Stiskni ENTER pro návrat do hlavní nabídky...'
