#!/bin/bash

set -euo pipefail

LOGFILE="/var/log/kiosk-configAdmin.log"
exec > >(tee -a "$LOGFILE") 2>&1

# Track current step for error reporting
current_step="initial setup"

# Trap error and show message
trap 'echo -e "\n❌ Installation failed during: $current_step\nCheck the log at $LOGFILE for details." >&2' ERR

function section() {
    current_step="$1"
    echo -e "\n🛠️ === $current_step ==="
}

# Parse arguments
SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")
parent=$(dirname "$dir")
kioskuser=$1
adminuser=$2

if [[ -z "$kioskuser" || -z "$adminuser" ]]; then
    echo "❌ Error: You must pass kioskuser and adminuser as arguments."
    exit 1
fi

section "Pridani admin uzivatele do skupiny dialout"
adduser $adminuser dialout

section "Pridani admin uzivatele do skupiny plugdev"
adduser $adminuser plugdev

section "Konfigurace Power options"
cat <<EOF | sudo tee /home/adminuser/.config/powermanagementprofilesrc > /dev/null
[AC][DPMSControl]
idleTime=0

[AC][SuspendSession]
idleTime=0
suspendType=0

[Battery][SuspendSession]
suspendType=0
idleTime=0
EOF

# Fix ownership and permissions
sudo chown adminuser:adminuser /home/adminuser/.config/powermanagementprofilesrc
sudo chmod 644 /home/adminuser/.config/powermanagementprofilesrc

cp $dir/wallpapers/admin.png /home/$adminuser/admin.png
chown $adminuser:$adminuser /home/$adminuser/admin.png

sudo -u $adminuser DISPLAY=:0 DBUS_SESSION_BUS_ADDRESS=unix:path=/run/user/$(id -u $adminuser)/bus plasma-apply-wallpaperimage /home/$adminuser/admin.png

section "✅ Hotovo"
read -rp $'\n🔸 Stiskni ENTER pro návrat do hlavní nabídky...'