#!/bin/bash

SCRIPT=$(realpath "$0")
dir=$(dirname "$SCRIPT")

ADMINUSER="adminuser"
KIOSKUSER="kioskuser"
RULE_FILE="/etc/polkit-1/rules.d/49-pkexec-kiosk.rules"

add_sudoers_for_adminuser() {
  local file="/etc/sudoers.d/${ADMINUSER}-kiosk"

  echo "🔧 Creating sudoers file for $ADMINUSER..."

  sudo bash -c "cat <<EOF > '$file'
$ADMINUSER ALL=(ALL) NOPASSWD: /usr/local/bin/switchUser.sh, /opt/admin/[0-9]_*.sh, /opt/kiosk/[0-9]_*.sh, /home/$ADMINUSER/Desktop/Scripts/*.sh
EOF"

  sudo chmod 440 "$file"
  sudo chown root:root "$file"

  if sudo visudo -cf "$file"; then
    echo "✅ Sudoers entry for $ADMINUSER is valid."
  else
    echo "❌ Invalid sudoers entry for $ADMINUSER. Removing it."
    sudo rm -f "$file"
    exit 1
  fi
}

add_sec_policies() {
echo "🔐 Creating PolicyKit rule at $RULE_FILE..."
sudo tee "$RULE_FILE" > /dev/null <<EOF
polkit.addRule(function(action, subject, details) {
    if (
        action.id == "org.freedesktop.policykit.exec" &&
        subject.user == "$KIOSKUSER" &&
        (
            details.command == "/usr/local/bin/switchUser.sh" ||
            details.command.match("^/opt/kiosk/[0-9]+_.*\\.sh$")
        )
    ) {
        return polkit.Result.YES;
    }

      if (subject.user == "$KIOSKUSER") {
          var prog = action.lookup("program");
          if (prog == "/usr/bin/usbrelay") {
            return polkit.Result.YES;
          }
      }

    if (
        action.id == "org.freedesktop.policykit.exec" &&
        subject.user == "$ADMINUSER" &&
        (
            details.command == "/usr/local/bin/switchUser.sh" ||
            details.command.match("^/opt/admin/[0-9]+_.*\\.sh$") ||
            details.command.match("^/opt/kiosk/[0-9]+_.*\\.sh$") ||
            details.command.match("^/home/adminuser/Desktop/Scripts/.*\\.sh$")
        )
    ) {
        return polkit.Result.YES;
    }

    if (subject.user == "$ADMINUSER") {
        var prog = action.lookup("program");
        if (prog == "/usr/local/sbin/kiosk-setup" ||
            prog == "/usr/bin/apt-get" ||
            prog == "/usr/bin/apt" ||
            prog == "/bin/systemctl") {
          return polkit.Result.YES;
        }
      }

    return null;
    }

    return null;
});
EOF

# Set secure permissions
sudo chmod 644 "$RULE_FILE"
echo "✅ Rule file created and secured."

# No restart required, but let's confirm syntax is okay
echo "🧪 Validating rule..."
sudo systemctl restart polkit.service
sleep 2
echo "✅ PolicyKit rules should now be active."
}

add_sudoers_for_adminuser
add_sec_policies

find $dir -type f -name "*.sh" -exec chmod a+x {} \;

pkexec apt install dialog -y

read -p "Hotovo. Muzete zavrit Konzoli."
exit 0
